<#--
 # The contents of this file are subject to the terms of the Common Development and
 # Distribution License (the License). You may not use this file except in compliance with the
 # License.
 #
 # You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 # specific language governing permission and limitations under the License.
 #
 # When distributing Covered Software, include this CDDL Header Notice in each file and include
 # the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 # Header, with the fields enclosed by brackets [] replaced by your own identifying
 # information: "Portions Copyright [year] [name of copyright owner]".
 #
 # Copyright 2017 ForgeRock AS.
 #-->
/* Text and blocks */
html, body, #container {
  height: 100%;
}
body {
  color: #333;
  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
}
body > #container {
  height: auto;
  min-height: 100%;
  padding-bottom: 3em;
}
code {
  background-color: #f9f2f4;
  border-radius: 4px;
  color: #c7254e;
  font-family: Menlo, Monaco, Consolas, "Courier New", monospace;
  font-size: 90%;
  font-weight: bold;
  padding: 2px 4px;
}
h1, h2, h3, h4, h5, h6 {
  font-family: inherit;
  font-weight: 500;
}
.list:not(:last-of-type), .section:not(:last-of-type) {
  border-bottom: 1px #aaa solid;
}
footer {
  clear: both;
  color: #aaa;
  font-size: 75%;
  font-style: italic;
  height: 3em;
  margin-top: -3em;
  position: relative;
  text-align: right;
  z-index: 10;
}

/* Lists */
.tab-list {
  margin-left: 0;
  padding: 0;
}
.tab-list li {
  background-color: #eee;
  border: 1px #aaa solid;
  border-bottom: 0;
  webkit-border-top-right-radius: 0.25em;
  -webkit-border-top-left-radius: 0.25em;
  -moz-border-radius-topright: 0.25em;
  -moz-border-radius-topleft: 0.25em;
  border-top-right-radius: 0.25em;
  border-top-left-radius: 0.25em;
  display: inline;
  list-style: none;
  padding: 0 0.25em;
}
.tab-list li a {
  padding: 0.25em 0;
}
li.selected {
  background: white;
}
.alpha-list, .jump-list {
  list-style: none;
  margin-left: 0;
  padding: 0;
}
.alpha-list::before, .jump-list::before {
  content: "Jump to: ";
  font-weight: bold;
}
.alpha-list > li, .jump-list>li {
  display: inline;
}
.jump-list>li:not(:last-child)::after {
  content: ", ";
}
.menu > .section > ul {
  list-style: none;
  margin-bottom: 0.5em;
  padding: 0;
}
.menu > .section > ul > li {
  padding-bottom: 0.5em;
}
li > ul, ul > ul {
  list-style: disc;
  margin-left: 0.5em;
  padding: 0 0 0.5em 1.0em;
}
.properties-list li::before {
  content: "\2193 ";
  display: inline;
  padding-right: 0.5em;
}
.properties-list ul {
  list-style: none;
  margin-left: 0;
  padding: 0;
  -webkit-column-break-inside: avoid;
  page-break-inside: avoid;
  break-inside: avoid;
}
.properties-list {
  -webkit-column-count: 2;
  -moz-column-count: 2;
  column-count: 2;
  -webkit-column-span: none;
  -moz-column-span: none;
  column-span: none;
  padding-bottom: 0.5em;
}
.properties-list p:last-of-type {
  padding-top: 1em;
}
.property-name {
  background-color: #eee;
  border-top: dotted 1px #ddd;
  font-family: Menlo, Monaco, Consolas, "Courier New", monospace;
  font-size: 90%;
  font-weight: bold;
  margin-bottom: -2px;
  padding: 2px 4px;
}
td {
  border-top: dotted 1px #ddd;
  line-height: 1.2;
  padding: 2px 4px;
}
td > p {
  margin-top: 0;
  margin-bottom: 0.5em;
}
.first-column {
  width: 25%;
}
tr {
  vertical-align: top;
}
table {
  padding-bottom: 0.5em;
  width: 100%;
}

/* Links */
a[href] {
  color: rgba(30, 63, 75, 0.75);
  text-decoration: none;
}
a[href]:active, a[href]:hover, a[href]:focus {
  color: #1e3f4b;
  text-decoration: underline;
}
