/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public class DescribableRequestHandler
implements RequestHandler,
Describable<ApiDescription, Request> {
    private final RequestHandler delegate;
    private final Describable<ApiDescription, Request> describableDelegate;
    private ApiDescription api;

    public DescribableRequestHandler(RequestHandler handler) {
        this.delegate = Reject.checkNotNull(handler);
        this.describableDelegate = this.delegate instanceof Describable ? (Describable)((Object)this.delegate) : null;
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.delegate.handleAction(this.wrap(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return this.delegate.handleCreate(this.wrap(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return this.delegate.handleDelete(this.wrap(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.delegate.handlePatch(this.wrap(context), request);
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.delegate.handleQuery(this.wrap(context), request, handler);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.delegate.handleRead(this.wrap(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.delegate.handleUpdate(this.wrap(context), request);
    }

    protected Context wrap(Context context) {
        return context;
    }

    @Override
    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        if (this.describableDelegate != null) {
            this.api = this.describableDelegate.api(producer);
        }
        return this.api;
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        return this.api;
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        if (this.describableDelegate != null) {
            this.describableDelegate.addDescriptorListener(listener);
        }
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.describableDelegate != null) {
            this.describableDelegate.removeDescriptorListener(listener);
        }
    }
}

