/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AbandonRequestImpl;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.AddRequestImpl;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindRequestImpl;
import org.forgerock.opendj.ldap.messages.CancelExtendedRequest;
import org.forgerock.opendj.ldap.messages.CancelExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareRequestImpl;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.DeleteRequestImpl;
import org.forgerock.opendj.ldap.messages.GenericExtendedRequest;
import org.forgerock.opendj.ldap.messages.GenericExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.InvalidRequest;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyDnRequestImpl;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequestImpl;
import org.forgerock.opendj.ldap.messages.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.messages.PasswordModifyExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.SaslClients;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchRequestImpl;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedRequest;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.messages.UnbindRequestImpl;
import org.forgerock.opendj.ldap.messages.UnknownRequest;
import org.forgerock.opendj.ldap.messages.UnmodifiableAbandonRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableAddRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableBindRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableCancelExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableCompareRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableDeleteRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableGenericExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableModifyDnRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableModifyRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiablePasswordModifyExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableSearchRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableStartTlsExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableUnbindRequestImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableWhoAmIExtendedRequestImpl;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedRequest;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedRequestImpl;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.LdifChangeRecordReader;
import org.forgerock.util.Reject;

public final class Requests {
    public static Dn dnOfRequest(Request request) {
        switch (request.getType()) {
            case ADD: {
                return ((AddRequest)request).getName();
            }
            case BIND: {
                return Requests.dnOfBindRequest((BindRequest)request);
            }
            case COMPARE: {
                return ((CompareRequest)request).getName();
            }
            case DELETE: {
                return ((DeleteRequest)request).getName();
            }
            case EXTENDED: {
                if (!(request instanceof PasswordModifyExtendedRequest)) break;
                return Requests.dnOfAuthzid(((PasswordModifyExtendedRequest)request).getUserIdentityAsString());
            }
            case MODIFYDN: {
                return ((ModifyDnRequest)request).getName();
            }
            case MODIFY: {
                return ((ModifyRequest)request).getName();
            }
            case SEARCH: {
                return ((SearchRequest)request).getName();
            }
        }
        return null;
    }

    private static Dn dnOfBindRequest(BindRequest bindRequest) {
        if (bindRequest.isSimpleBindRequest()) {
            return Requests.dnOf(bindRequest.getName());
        }
        byte[] saslCredentials = bindRequest.getSaslCredentials();
        if (saslCredentials != null && bindRequest.getSaslMechanism().equalsIgnoreCase("PLAIN")) {
            int start = 0;
            int end = 0;
            for (int i = 0; i < saslCredentials.length; ++i) {
                if (saslCredentials[i] != 0) continue;
                if (start == 0) {
                    start = i + 1;
                    continue;
                }
                end = i;
                break;
            }
            if (end != 0) {
                return Requests.dnOfAuthzid(ByteString.wrap(saslCredentials, start, end - start).toString());
            }
        }
        return null;
    }

    private static Dn dnOf(String dnString) {
        try {
            return Dn.valueOf(dnString);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static Dn dnOfAuthzid(String authzid) {
        if (authzid != null && authzid.startsWith("dn:")) {
            return Requests.dnOf(authzid.substring(3));
        }
        return null;
    }

    public static Request shallowCopyOfRequest(Request request, String ... excludeControlOids) {
        return Requests.shallowCopyOfRequest(request, Arrays.asList(excludeControlOids));
    }

    public static Request shallowCopyOfRequest(Request request, Collection<String> excludeControlOids) {
        if (request instanceof AbandonRequest) {
            AbandonRequest req = Requests.copyOfAbandonRequest((AbandonRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof AddRequest) {
            AddRequest req = (AddRequest)request;
            AddRequest newReq = Requests.newAddRequest(new LinkedHashMapEntry(req));
            return Requests.copyControls(req, newReq, excludeControlOids);
        }
        if (request instanceof BindRequest) {
            BindRequest req = Requests.copyOfBindRequest((BindRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof CancelExtendedRequest) {
            CancelExtendedRequest req = Requests.copyOfCancelExtendedRequest((CancelExtendedRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof CompareRequest) {
            CompareRequest req = Requests.copyOfCompareRequest((CompareRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof DeleteRequest) {
            DeleteRequest req = Requests.copyOfDeleteRequest((DeleteRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof GenericExtendedRequest) {
            GenericExtendedRequest req = Requests.copyOfGenericExtendedRequest((GenericExtendedRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof ModifyDnRequest) {
            ModifyDnRequest req = Requests.copyOfModifyDnRequest((ModifyDnRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof ModifyRequest) {
            ModifyRequest req = (ModifyRequest)request;
            ModifyRequest newReq = Requests.newModifyRequest(req.getName());
            for (Modification mod : req.getModifications()) {
                newReq.addModification(mod);
            }
            return Requests.copyControls(req, newReq, excludeControlOids);
        }
        if (request instanceof PasswordModifyExtendedRequest) {
            PasswordModifyExtendedRequest req = Requests.copyOfPasswordModifyExtendedRequest((PasswordModifyExtendedRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof SearchRequest) {
            SearchRequest req = Requests.copyOfSearchRequest((SearchRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof StartTlsExtendedRequest) {
            StartTlsExtendedRequest req = Requests.copyOfStartTlsExtendedRequest((StartTlsExtendedRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof UnbindRequest) {
            UnbindRequest req = Requests.copyOfUnbindRequest((UnbindRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        if (request instanceof WhoAmIExtendedRequest) {
            WhoAmIExtendedRequest req = Requests.copyOfWhoAmIExtendedRequest((WhoAmIExtendedRequest)request);
            Requests.filterControls(req.getControls(), excludeControlOids);
            return req;
        }
        throw new LocalizedIllegalArgumentException(CoreMessages.ERR_UNKNOWN_REQUEST_TYPE.get(request));
    }

    private static Request copyControls(Request source, Request destination, Collection<String> excludeControlOids) {
        for (Control control : source.getControls()) {
            if (excludeControlOids.contains(control.getOid())) continue;
            destination.addControl(control);
        }
        return destination;
    }

    private static void filterControls(List<Control> controls, Collection<String> excludedControlOids) {
        Iterator<Control> it = controls.iterator();
        while (it.hasNext()) {
            Control control = it.next();
            if (!excludedControlOids.contains(control.getOid())) continue;
            it.remove();
        }
    }

    public static AbandonRequest copyOfAbandonRequest(AbandonRequest request) {
        return new AbandonRequestImpl(request);
    }

    public static AddRequest copyOfAddRequest(AddRequest request) {
        return new AddRequestImpl(request);
    }

    public static CancelExtendedRequest copyOfCancelExtendedRequest(CancelExtendedRequest request) {
        return new CancelExtendedRequestImpl(request);
    }

    public static CompareRequest copyOfCompareRequest(CompareRequest request) {
        return new CompareRequestImpl(request);
    }

    public static DeleteRequest copyOfDeleteRequest(DeleteRequest request) {
        return new DeleteRequestImpl(request);
    }

    public static BindRequest copyOfBindRequest(BindRequest request) {
        return new BindRequestImpl(request);
    }

    public static GenericExtendedRequest copyOfGenericExtendedRequest(GenericExtendedRequest request) {
        return new GenericExtendedRequestImpl(request);
    }

    public static ModifyDnRequest copyOfModifyDnRequest(ModifyDnRequest request) {
        return new ModifyDnRequestImpl(request);
    }

    public static ModifyRequest copyOfModifyRequest(ModifyRequest request) {
        return new ModifyRequestImpl(request);
    }

    public static PasswordModifyExtendedRequest copyOfPasswordModifyExtendedRequest(PasswordModifyExtendedRequest request) {
        return new PasswordModifyExtendedRequestImpl(request);
    }

    public static SearchRequest copyOfSearchRequest(SearchRequest request) {
        return new SearchRequestImpl(request);
    }

    public static StartTlsExtendedRequest copyOfStartTlsExtendedRequest(StartTlsExtendedRequest request) {
        return new StartTlsExtendedRequestImpl(request);
    }

    public static UnbindRequest copyOfUnbindRequest(UnbindRequest request) {
        return new UnbindRequestImpl(request);
    }

    public static WhoAmIExtendedRequest copyOfWhoAmIExtendedRequest(WhoAmIExtendedRequest request) {
        return new WhoAmIExtendedRequestImpl(request);
    }

    public static AbandonRequest newAbandonRequest(int requestID) {
        return new AbandonRequestImpl(requestID);
    }

    public static AddRequest newAddRequest(Dn name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(Entry entry) {
        Reject.ifNull(entry);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(String name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(String ... ldifLines) {
        ChangeRecord record = LdifChangeRecordReader.valueOfLdifChangeRecord(ldifLines);
        if (record instanceof AddRequest) {
            return (AddRequest)record;
        }
        LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_CHANGE_RECORD_WRONG_TYPE.get("add");
        throw new LocalizedIllegalArgumentException(message);
    }

    public static CancelExtendedRequest newCancelExtendedRequest(int requestID) {
        return new CancelExtendedRequestImpl(requestID);
    }

    public static ChangeRecord newChangeRecord(String ... ldifLines) {
        return LdifChangeRecordReader.valueOfLdifChangeRecord(ldifLines);
    }

    public static CompareRequest newCompareRequest(Dn name, AttributeDescription attributeDescription, Object assertionValue) {
        Reject.ifNull(name, attributeDescription, assertionValue);
        return new CompareRequestImpl(name, attributeDescription, ByteString.valueOfObject(assertionValue));
    }

    public static CompareRequest newCompareRequest(String name, String attributeDescription, Object assertionValue) {
        Reject.ifNull(name, attributeDescription, assertionValue);
        return new CompareRequestImpl(Dn.valueOf(name), AttributeDescription.valueOf(attributeDescription), ByteString.valueOfObject(assertionValue));
    }

    public static DeleteRequest newDeleteRequest(Dn name) {
        Reject.ifNull(name);
        return new DeleteRequestImpl(name);
    }

    public static DeleteRequest newDeleteRequest(String name) {
        Reject.ifNull(name);
        return new DeleteRequestImpl(Dn.valueOf(name));
    }

    public static BindRequest newAnonymousBindRequest() {
        return new BindRequestImpl();
    }

    public static BindRequest newBindRequest() {
        return new BindRequestImpl();
    }

    public static BindRequest newSaslBindRequest(SaslClient saslClient) {
        return Requests.newBindRequest().setSaslMechanismAndCredentials(saslClient);
    }

    public static BindRequest newAnonymousSaslBindRequest(String traceString) {
        return Requests.newSaslBindRequest(SaslClients.newAnonymousSaslClient(traceString));
    }

    public static BindRequest newPlainSaslBindRequest(String authenticationId, char[] password, String authorizationId) {
        return Requests.newSaslBindRequest(SaslClients.newPlainClient(authenticationId, password, authorizationId));
    }

    public static BindRequest newExternalSaslBindRequest(String authorizationId) {
        return Requests.newSaslBindRequest(SaslClients.newExternalClient(authorizationId));
    }

    public static BindRequest newCramMd5SaslBindRequest(String authenticationId, char[] password) {
        return Requests.newSaslBindRequest(SaslClients.newCramMd5Client(authenticationId, password));
    }

    public static BindRequest newDigestMd5SaslBindRequest(String serverName, String authenticationId, char[] password, String authorizationId, String realm, Map<String, ?> properties) {
        return Requests.newSaslBindRequest(SaslClients.newDigestMd5Client(serverName, authenticationId, password, authorizationId, realm, properties));
    }

    public static BindRequest newGssapiSaslBindRequest(String serverName, Subject subject, String authorizationId, Map<String, ?> properties) {
        return Requests.newSaslBindRequest(SaslClients.newGssapiClient(serverName, subject, authorizationId, properties));
    }

    public static GenericExtendedRequest newGenericExtendedRequest(String requestName) {
        Reject.ifNull(requestName);
        return new GenericExtendedRequestImpl(requestName);
    }

    public static GenericExtendedRequest newGenericExtendedRequest(String requestName, Object requestValue) {
        Reject.ifNull(requestName);
        return new GenericExtendedRequestImpl(requestName).setValue(requestValue);
    }

    public static InvalidRequest newInvalidRequest(Request.RequestType invalidRequestType, String invalidRawDn, LdapException reason) {
        return new InvalidRequest(invalidRequestType, invalidRawDn, reason);
    }

    public static ModifyDnRequest newModifyDnRequest(Dn name, Rdn newRDN) {
        Reject.ifNull(name);
        Reject.ifNull(newRDN);
        return new ModifyDnRequestImpl(name, newRDN);
    }

    public static ModifyDnRequest newModifyDnRequest(String name, String newRDN) {
        Reject.ifNull(name, newRDN);
        return new ModifyDnRequestImpl(Dn.valueOf(name), Rdn.valueOf(newRDN));
    }

    public static ModifyRequest newModifyRequest(Dn name) {
        Reject.ifNull(name);
        return new ModifyRequestImpl(name);
    }

    public static ModifyRequest newModifyRequest(Entry fromEntry, Entry toEntry) {
        return Entries.diffEntries(fromEntry, toEntry);
    }

    public static ModifyRequest newModifyRequest(String name) {
        Reject.ifNull(name);
        return new ModifyRequestImpl(Dn.valueOf(name));
    }

    public static ModifyRequest newModifyRequest(String ... ldifLines) {
        ChangeRecord record = LdifChangeRecordReader.valueOfLdifChangeRecord(ldifLines);
        if (record instanceof ModifyRequest) {
            return (ModifyRequest)record;
        }
        LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_CHANGE_RECORD_WRONG_TYPE.get("modify");
        throw new LocalizedIllegalArgumentException(message);
    }

    public static PasswordModifyExtendedRequest newPasswordModifyExtendedRequest() {
        return new PasswordModifyExtendedRequestImpl();
    }

    public static SearchRequest newSearchRequest(Dn name, SearchScope scope, Filter filter, String ... attributeDescriptions) {
        Reject.ifNull(name, scope, filter);
        SearchRequestImpl request = new SearchRequestImpl(name, scope, filter);
        for (String attributeDescription : attributeDescriptions) {
            request.addAttribute(attributeDescription);
        }
        return request;
    }

    public static SearchRequest newSearchRequest(String name, SearchScope scope, String filter, String ... attributeDescriptions) {
        Reject.ifNull(name, scope, filter);
        SearchRequestImpl request = new SearchRequestImpl(Dn.valueOf(name), scope, Filter.valueOf(filter));
        for (String attributeDescription : attributeDescriptions) {
            request.addAttribute(attributeDescription);
        }
        return request;
    }

    public static SearchRequest newSearchRequest(Dn name, SearchScope scope) {
        return Requests.newSearchRequest(name, scope, Filter.objectClassPresent(), new String[0]);
    }

    public static SearchRequest newSearchRequest(String name, SearchScope scope) {
        return Requests.newSearchRequest(Dn.valueOf(name), scope, Filter.objectClassPresent(), new String[0]);
    }

    public static SearchRequest newSingleEntrySearchRequest(Dn name, SearchScope scope, Filter filter, String ... attributeDescriptions) {
        return Requests.newSearchRequest(name, scope, filter, attributeDescriptions).setSizeLimit(1);
    }

    public static SearchRequest newSingleEntrySearchRequest(String name, SearchScope scope, String filter, String ... attributeDescriptions) {
        return Requests.newSearchRequest(name, scope, filter, attributeDescriptions).setSizeLimit(1);
    }

    public static BindRequest newSimpleBindRequest(String name, byte[] password) {
        return new BindRequestImpl().setName(name).setSimplePassword(password);
    }

    public static BindRequest newSimpleBindRequest(String name, char[] password) {
        Reject.ifNull(name, password);
        return Requests.newSimpleBindRequest(name, StaticUtils.getBytes(password));
    }

    public static BindRequest newSimpleBindRequest(String name, String password) {
        Reject.ifNull(name, password);
        return Requests.newSimpleBindRequest(name, StaticUtils.getBytes(password));
    }

    public static BindRequest newSimpleBindRequest(Dn name, char[] password) {
        Reject.ifNull(name, password);
        return Requests.newSimpleBindRequest(name.toString(), StaticUtils.getBytes(password));
    }

    public static BindRequest newSimpleBindRequest(Dn name, String password) {
        Reject.ifNull(name, password);
        return Requests.newSimpleBindRequest(name.toString(), StaticUtils.getBytes(password));
    }

    public static StartTlsExtendedRequest newStartTlsExtendedRequest(SslOptions sslOptions) {
        return new StartTlsExtendedRequestImpl(sslOptions);
    }

    public static UnbindRequest newUnbindRequest() {
        return new UnbindRequestImpl();
    }

    public static UnknownRequest newUnknownRequest(byte protocolOpType, ByteString rawContent) {
        return new UnknownRequest(protocolOpType, rawContent);
    }

    public static WhoAmIExtendedRequest newWhoAmIExtendedRequest() {
        return new WhoAmIExtendedRequestImpl();
    }

    public static AbandonRequest unmodifiableAbandonRequest(AbandonRequest request) {
        if (request instanceof UnmodifiableAbandonRequestImpl) {
            return request;
        }
        return new UnmodifiableAbandonRequestImpl(request);
    }

    public static AddRequest unmodifiableAddRequest(AddRequest request) {
        if (request instanceof UnmodifiableAddRequestImpl) {
            return request;
        }
        return new UnmodifiableAddRequestImpl(request);
    }

    public static CancelExtendedRequest unmodifiableCancelExtendedRequest(CancelExtendedRequest request) {
        if (request instanceof UnmodifiableCancelExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableCancelExtendedRequestImpl(request);
    }

    public static CompareRequest unmodifiableCompareRequest(CompareRequest request) {
        if (request instanceof UnmodifiableCompareRequestImpl) {
            return request;
        }
        return new UnmodifiableCompareRequestImpl(request);
    }

    public static DeleteRequest unmodifiableDeleteRequest(DeleteRequest request) {
        if (request instanceof UnmodifiableDeleteRequestImpl) {
            return request;
        }
        return new UnmodifiableDeleteRequestImpl(request);
    }

    public static BindRequest unmodifiableBindRequest(BindRequest request) {
        if (request instanceof UnmodifiableBindRequestImpl) {
            return request;
        }
        return new UnmodifiableBindRequestImpl(request);
    }

    public static GenericExtendedRequest unmodifiableGenericExtendedRequest(GenericExtendedRequest request) {
        if (request instanceof UnmodifiableGenericExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableGenericExtendedRequestImpl(request);
    }

    public static ModifyDnRequest unmodifiableModifyDnRequest(ModifyDnRequest request) {
        if (request instanceof UnmodifiableModifyDnRequestImpl) {
            return request;
        }
        return new UnmodifiableModifyDnRequestImpl(request);
    }

    public static ModifyRequest unmodifiableModifyRequest(ModifyRequest request) {
        if (request instanceof UnmodifiableModifyRequestImpl) {
            return request;
        }
        return new UnmodifiableModifyRequestImpl(request);
    }

    public static PasswordModifyExtendedRequest unmodifiablePasswordModifyExtendedRequest(PasswordModifyExtendedRequest request) {
        if (request instanceof UnmodifiablePasswordModifyExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiablePasswordModifyExtendedRequestImpl(request);
    }

    public static SearchRequest unmodifiableSearchRequest(SearchRequest request) {
        if (request instanceof UnmodifiableSearchRequestImpl) {
            return request;
        }
        return new UnmodifiableSearchRequestImpl(request);
    }

    public static StartTlsExtendedRequest unmodifiableStartTlsExtendedRequest(StartTlsExtendedRequest request) {
        if (request instanceof UnmodifiableStartTlsExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableStartTlsExtendedRequestImpl(request);
    }

    public static UnbindRequest unmodifiableUnbindRequest(UnbindRequest request) {
        if (request instanceof UnmodifiableUnbindRequestImpl) {
            return request;
        }
        return new UnmodifiableUnbindRequestImpl(request);
    }

    public static WhoAmIExtendedRequest unmodifiableWhoAmIExtendedRequest(WhoAmIExtendedRequest request) {
        if (request instanceof UnmodifiableWhoAmIExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableWhoAmIExtendedRequestImpl(request);
    }

    private Requests() {
    }
}

