/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.util.Reject;

final class ModifyDnRequestImpl
extends AbstractProtocolOpImpl<ModifyDnRequest>
implements ModifyDnRequest {
    private boolean deleteOldRdn;
    private Dn name;
    private Rdn newRdn;
    private Dn newSuperior;

    ModifyDnRequestImpl(Dn name, Rdn newRdn) {
        this.name = name;
        this.newRdn = newRdn;
    }

    ModifyDnRequestImpl(ModifyDnRequest modifyDnRequest) {
        super(modifyDnRequest);
        this.name = modifyDnRequest.getName();
        this.newSuperior = modifyDnRequest.getNewSuperior();
        this.newRdn = modifyDnRequest.getNewRdn();
        this.deleteOldRdn = modifyDnRequest.isDeleteOldRdn();
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public Rdn getNewRdn() {
        return this.newRdn;
    }

    @Override
    public Dn getNewSuperior() {
        return this.newSuperior;
    }

    @Override
    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    @Override
    public ModifyDnRequestImpl setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
        return this;
    }

    @Override
    public ModifyDnRequest setName(Dn dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public ModifyDnRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = Dn.valueOf(dn);
        return this;
    }

    @Override
    public ModifyDnRequest setNewRdn(Rdn rdn) {
        Reject.ifNull(rdn);
        this.newRdn = rdn;
        return this;
    }

    @Override
    public ModifyDnRequest setNewRdn(String rdn) {
        Reject.ifNull(rdn);
        this.newRdn = Rdn.valueOf(rdn);
        return this;
    }

    @Override
    public ModifyDnRequest setNewSuperior(Dn dn) {
        this.newSuperior = dn;
        return this;
    }

    @Override
    public ModifyDnRequest setNewSuperior(String dn) {
        this.newSuperior = dn != null ? Dn.valueOf(dn) : null;
        return this;
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.MODIFYDN;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyDnRequest(name=");
        builder.append(this.getName());
        builder.append(", newRdn=");
        builder.append(this.getNewRdn());
        builder.append(", deleteOldRdn=");
        builder.append(this.isDeleteOldRdn());
        builder.append(", newSuperior=");
        builder.append(this.getNewSuperior());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    ModifyDnRequest getThis() {
        return this;
    }
}

