/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.EOFException;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.grizzly.GrizzlyLdapConnection;
import org.forgerock.opendj.grizzly.SaslClientFilter;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapListener;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.IntermediateResponse;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.ProtocolOp;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedRequest;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

final class LdapClientFilter
extends BaseFilter {
    private final GrizzlyLdapConnection ldapConnection;

    LdapClientFilter(GrizzlyLdapConnection ldapConnection) {
        this.ldapConnection = ldapConnection;
    }

    private void setFinalResult(int messageID, Class<? extends Request> expectedRequestClass, Result result) throws IOException {
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.removePendingRequest(messageID);
        if (pendingRequest != null) {
            if (expectedRequestClass.isAssignableFrom(pendingRequest.getRequest().getClass())) {
                pendingRequest.setResultOrError(result);
            } else {
                throw this.newUnexpectedResponseException(messageID, result);
            }
        }
    }

    private void bindResult(FilterChainContext context, int messageID, BindResult result) throws IOException {
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.removePendingRequest(messageID);
        if (pendingRequest == null) {
            return;
        }
        if (!(pendingRequest.getRequest() instanceof BindRequest)) {
            throw this.newUnexpectedResponseException(messageID, result);
        }
        BindRequest request = (BindRequest)pendingRequest.getRequest();
        SaslClient saslClient = request.getSaslClient();
        if (!request.isSaslBindRequest() || saslClient == null) {
            this.ldapConnection.setBindOrStartTlsInProgress(result.getResultCode() == ResultCode.SASL_BIND_IN_PROGRESS);
            pendingRequest.setResultOrError(result);
            return;
        }
        if (result.getResultCode().isExceptional()) {
            this.ldapConnection.setBindOrStartTlsInProgress(false);
            pendingRequest.setResultOrError(result);
            LdapClientFilter.disposeSaslClient(saslClient);
            return;
        }
        try {
            ByteString serverSASLCredentials = result.getServerSaslCredentials();
            final BindRequest nextBindRequest = request.evaluateSaslChallenge(serverSASLCredentials != null ? serverSASLCredentials.toByteArray() : StaticUtils.EMPTY_BYTES);
            if (nextBindRequest != null) {
                int msgID = this.ldapConnection.continuePendingBindRequest(pendingRequest);
                context.getConnection().write(LdapMessage.newLdapMessage(msgID, (byte)96, nextBindRequest)).addCompletionHandler(new EmptyCompletionHandler(){

                    @Override
                    public void failed(Throwable throwable) {
                        nextBindRequest.destroy();
                    }

                    @Override
                    public void completed(Object result) {
                        nextBindRequest.destroy();
                    }
                });
                return;
            }
            if (request.hasNegotiatedSaslQop()) {
                MemoryManager memoryManager = context.getConnection().getTransport().getMemoryManager();
                this.ldapConnection.installFilter(new SaslClientFilter(saslClient, memoryManager));
            } else {
                LdapClientFilter.disposeSaslClient(saslClient);
            }
            this.ldapConnection.setBindOrStartTlsInProgress(false);
            pendingRequest.setResultOrError(result);
        }
        catch (IOException e) {
            this.ldapConnection.setBindOrStartTlsInProgress(false);
            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage(CoreMessages.ERR_SASL_BIND_MULTI_STAGE.get(e.getLocalizedMessage())).setCause(e);
            pendingRequest.adaptErrorResult(errorResult);
            LdapClientFilter.disposeSaslClient(saslClient);
        }
    }

    private DecodeException newUnexpectedResponseException(int messageID, Response response) {
        return DecodeException.fatalError(LocalizableMessage.raw("Unexpected LDAP response: id=%d, message=%s", messageID, response));
    }

    private static void disposeSaslClient(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    private void extendedResult(int messageID, ExtendedResult result) throws IOException {
        if (messageID == 0) {
            if ("1.3.6.1.4.1.1466.20036".equals(result.getOid())) {
                Result errorResult = Responses.newResult(result.getResultCode()).setDiagnosticMessage(result.getDiagnosticMessage());
                this.ldapConnection.close(null, true, errorResult);
            } else {
                this.ldapConnection.handleUnsolicitedNotification(result);
            }
        } else {
            ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.removePendingRequest(messageID);
            if (pendingRequest != null) {
                if (pendingRequest.getRequest() instanceof ExtendedRequest) {
                    ExtendedResultLdapPromiseImpl extendedPromise = (ExtendedResultLdapPromiseImpl)pendingRequest;
                    try {
                        this.handleExtendedResult0(extendedPromise, result);
                    }
                    catch (DecodeException de) {
                        Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_DECODING_ERROR).setDiagnosticMessage(de.getLocalizedMessage()).setCause(de);
                        extendedPromise.adaptErrorResult(errorResult);
                    }
                } else {
                    throw this.newUnexpectedResponseException(messageID, result);
                }
            }
        }
    }

    private void intermediateResponse(int messageID, IntermediateResponse response) throws IOException {
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.getPendingRequest(messageID);
        if (pendingRequest != null) {
            pendingRequest.handleIntermediateResponse(response);
        }
    }

    private void searchResultEntry(int messageID, SearchResultEntry entry) throws IOException {
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.getPendingRequest(messageID);
        if (pendingRequest != null) {
            if (pendingRequest instanceof SearchResultLdapPromiseImpl) {
                ((SearchResultLdapPromiseImpl)pendingRequest).handleEntry(entry);
            } else {
                throw this.newUnexpectedResponseException(messageID, entry);
            }
        }
    }

    private void searchResultReference(int messageID, SearchResultReference reference) throws IOException {
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.ldapConnection.getPendingRequest(messageID);
        if (pendingRequest != null) {
            if (pendingRequest instanceof SearchResultLdapPromiseImpl) {
                ((SearchResultLdapPromiseImpl)pendingRequest).handleReference(reference);
            } else {
                throw this.newUnexpectedResponseException(messageID, reference);
            }
        }
    }

    private <R extends ExtendedResult> void handleExtendedResult0(final ExtendedResultLdapPromiseImpl<R> promise, ExtendedResult result) throws DecodeException {
        final R decodedResponse = promise.decodeResult(result, (DecodeOptions)this.ldapConnection.getLdapOptions().get(LdapListener.LDAP_DECODE_OPTIONS));
        if (result.getResultCode() == ResultCode.SUCCESS && promise.getRequest() instanceof StartTlsExtendedRequest) {
            try {
                StartTlsExtendedRequest request = (StartTlsExtendedRequest)promise.getRequest();
                this.ldapConnection.startTls(request.getSslOptions(), (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                    @Override
                    public void completed(SSLEngine result) {
                        LdapClientFilter.this.ldapConnection.setBindOrStartTlsInProgress(false);
                        promise.setResultOrError(decodedResponse);
                    }

                    @Override
                    public void failed(Throwable throwable) {
                        Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(throwable).setDiagnosticMessage("SSL handshake failed");
                        LdapClientFilter.this.ldapConnection.setBindOrStartTlsInProgress(false);
                        LdapClientFilter.this.ldapConnection.close(null, false, errorResult);
                        promise.adaptErrorResult(errorResult);
                    }
                });
                return;
            }
            catch (IOException e) {
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(e).setDiagnosticMessage(e.getMessage());
                promise.adaptErrorResult(errorResult);
                this.ldapConnection.close(null, false, errorResult);
                return;
            }
        }
        promise.setResultOrError(decodedResponse);
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (!connection.isOpen()) {
            return;
        }
        Result errorResult = error instanceof EOFException ? Responses.newResult(ResultCode.CLIENT_SIDE_SERVER_DOWN).setCause(error) : Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(error);
        this.ldapConnection.close(null, false, errorResult);
    }

    @Override
    public final NextAction handleRead(FilterChainContext ctx) throws IOException {
        LdapMessage ldapMessage = (LdapMessage)ctx.getMessage();
        int messageId = ldapMessage.getMessageId();
        ProtocolOp protocolOp = ldapMessage.getProtocolOp();
        switch (ldapMessage.getProtocolOpType()) {
            case 105: {
                this.setFinalResult(messageId, AddRequest.class, (Result)protocolOp);
                break;
            }
            case 97: {
                this.bindResult(ctx, messageId, (BindResult)protocolOp);
                break;
            }
            case 111: {
                this.setFinalResult(messageId, CompareRequest.class, (Result)protocolOp);
                break;
            }
            case 107: {
                this.setFinalResult(messageId, DeleteRequest.class, (Result)protocolOp);
                break;
            }
            case 120: {
                this.extendedResult(messageId, (ExtendedResult)protocolOp);
                break;
            }
            case 121: {
                this.intermediateResponse(messageId, (IntermediateResponse)protocolOp);
                break;
            }
            case 109: {
                this.setFinalResult(messageId, ModifyDnRequest.class, (Result)protocolOp);
                break;
            }
            case 103: {
                this.setFinalResult(messageId, ModifyRequest.class, (Result)protocolOp);
                break;
            }
            case 101: {
                this.setFinalResult(messageId, SearchRequest.class, (Result)protocolOp);
                break;
            }
            case 100: {
                this.searchResultEntry(messageId, (SearchResultEntry)protocolOp);
                break;
            }
            case 115: {
                this.searchResultReference(messageId, (SearchResultReference)protocolOp);
                break;
            }
            default: {
                this.setFinalResult(messageId, Request.class, (Result)protocolOp);
            }
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        CloseReason reason = ctx.getConnection().getCloseReason();
        Result errorResult = reason.getCause() instanceof LdapException ? ((LdapException)reason.getCause()).getResult() : Responses.newResult(ResultCode.CLIENT_SIDE_SERVER_DOWN);
        this.ldapConnection.close(null, false, errorResult);
        return ctx.getInvokeAction();
    }
}

