/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.grizzly.GrizzlyMessages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import net.jcip.annotations.GuardedBy;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.GrizzlyLdapConnectionFactory;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.TimeoutEventListener;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.opendj.security.SslContextBuilder;
import org.forgerock.opendj.security.TrustManagers;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.time.Duration;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.utils.Exceptions;

final class GrizzlyLdapConnection
implements LdapConnectionImpl,
TimeoutEventListener {
    static final int LDAP_V3 = 3;
    private static final SSLEngineConfigurator DUMMY_SSL_ENGINE_CONFIGURATOR;
    private static final LocalizedLogger logger;
    private final AtomicBoolean bindOrStartTlsInProgress = new AtomicBoolean(false);
    private final Connection<?> connection;
    private final AtomicInteger nextMsgId = new AtomicInteger(1);
    private final GrizzlyLdapConnectionFactory factory;
    private final ConcurrentHashMap<Integer, ResultLdapPromiseImpl<?, ?>> pendingRequests = new ConcurrentHashMap();
    private final long requestTimeoutMs;
    private final Object stateLock = new Object();
    @GuardedBy(value="stateLock")
    private Result connectionInvalidReason;
    private boolean failedDueToDisconnect;
    private boolean isClosed;
    private boolean isFailed;
    private List<ConnectionEventListener> listeners;

    GrizzlyLdapConnection(Connection<?> connection, GrizzlyLdapConnectionFactory factory) {
        this.connection = connection;
        this.factory = factory;
        Duration requestTimeout = factory.getLdapOptions().get(LdapConnectionFactory.REQUEST_TIMEOUT);
        this.requestTimeoutMs = requestTimeout.isUnlimited() ? 0L : requestTimeout.to(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Void> abandonAsync(AbandonRequest request) {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
            }
        }
        catch (LdapException e) {
            return LdapPromises.newFailedLdapPromise(e);
        }
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.pendingRequests.remove(request.getRequestId());
        if (pendingRequest == null) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }
        pendingRequest.cancel(false);
        return this.sendAbandonRequest(request);
    }

    private LdapPromise<Void> sendAbandonRequest(AbandonRequest request) {
        final LdapPromiseImpl<Void> promise = LdapPromiseImpl.newLdapPromiseImpl();
        this.connection.write(LdapMessage.newLdapMessage(this.nextMsgId.getAndIncrement(), (byte)80, request), new EmptyCompletionHandler(){

            @Override
            public void failed(Throwable error) {
                promise.handleException(GrizzlyLdapConnection.this.adaptRequestIOException(Exceptions.makeIOException(error)));
            }

            @Override
            public void completed(Object result) {
                promise.handleResult(null);
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<AddRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)104, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    private void sendRequest(final int messageId, byte protocolOpType, Request request, final ResultLdapPromiseImpl promise, final Runnable onError) {
        this.connection.write(LdapMessage.newLdapMessage(messageId, protocolOpType, request), new EmptyCompletionHandler(){

            @Override
            public void failed(Throwable error) {
                GrizzlyLdapConnection.this.pendingRequests.remove(messageId);
                promise.adaptErrorResult(GrizzlyLdapConnection.this.adaptRequestIOException(Exceptions.makeIOException(error)).getResult());
                if (onError != null) {
                    onError.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Reject.ifNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            notifyClose = this.isClosed;
            notifyErrorOccurred = this.isFailed;
            if (!this.isClosed) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                }
                this.listeners.add(listener);
            }
        }
        if (notifyErrorOccurred) {
            listener.handleConnectionError(this.failedDueToDisconnect, LdapException.newLdapException(this.connectionInvalidReason));
        }
        if (notifyClose) {
            listener.handleConnectionClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<BindRequest, BindResult> promise = LdapPromises.newBindLdapPromise(messageID, request, intermediateResponseHandler);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                if (!this.pendingRequests.isEmpty()) {
                    promise.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("There are other operations pending on this connection"));
                    return promise;
                }
                if (!this.bindOrStartTlsInProgress.compareAndSet(false, true)) {
                    promise.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("Bind or Start TLS operation in progress"));
                    return promise;
                }
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)96, request, promise, new Runnable(){

                @Override
                public void run() {
                    GrizzlyLdapConnection.this.bindOrStartTlsInProgress.set(false);
                }
            });
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    @Override
    public void close() {
        this.close(Requests.newUnbindRequest(), null);
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        Reject.ifNull(request);
        this.close(request, false, Responses.newResult(ResultCode.CLIENT_SIDE_USER_CANCELLED).setDiagnosticMessage(reason != null ? reason : "Connection closed by client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<CompareRequest, CompareResult> promise = LdapPromises.newCompareLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)110, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<DeleteRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)74, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ExtendedResultLdapPromiseImpl<R> promise = LdapPromises.newExtendedLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                if ("1.3.6.1.4.1.1466.20037".equals(request.getOid())) {
                    if (!this.pendingRequests.isEmpty()) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "There are pending operations on this connection"));
                        return promise;
                    }
                    if (this.isTlsEnabled()) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "This connection is already TLS enabled"));
                        return promise;
                    }
                    if (!this.bindOrStartTlsInProgress.compareAndSet(false, true)) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "Bind or Start TLS operation in progress"));
                        return promise;
                    }
                } else {
                    this.checkBindOrStartTLSInProgress();
                }
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)119, request, promise, new Runnable(){

                @Override
                public void run() {
                    GrizzlyLdapConnection.this.bindOrStartTlsInProgress.set(false);
                }
            });
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isValid0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<ModifyRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)102, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        ResultLdapPromiseImpl<ModifyDnRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)108, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Reject.ifNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        int messageID = this.nextMsgId.getAndIncrement();
        SearchResultLdapPromiseImpl promise = LdapPromises.newSearchLdapPromise(messageID, request, entryHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            this.sendRequest(messageID, (byte)99, request, promise, null);
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    public String toString() {
        return this.connection.getLocalAddress() + "->" + this.connection.getPeerAddress();
    }

    @Override
    public long handleTimeout(long currentTime) {
        if (this.requestTimeoutMs <= 0L) {
            return 0L;
        }
        long delay = this.requestTimeoutMs;
        for (ResultLdapPromiseImpl<?, ?> promise : this.pendingRequests.values()) {
            Result result;
            if (promise == null || !promise.checkForTimeout()) continue;
            long diff = promise.getTimestamp() + this.requestTimeoutMs - currentTime;
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                continue;
            }
            if (this.pendingRequests.remove(promise.getRequestId()) == null) continue;
            if (promise.isBindOrStartTls()) {
                logger.debug(LocalizableMessage.raw("Failing bind or StartTLS request due to timeout %s(connection will be invalidated): ", promise));
                result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_BIND_OR_START_TLS_REQUEST_TIMEOUT.get(this.requestTimeoutMs));
                promise.adaptErrorResult(result);
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_BIND_OR_START_TLS_CONNECTION_TIMEOUT.get(this.requestTimeoutMs));
                this.connectionErrorOccurred(errorResult);
                continue;
            }
            logger.debug(LocalizableMessage.raw("Failing request due to timeout: %s", promise));
            result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_REQUEST_TIMEOUT.get(this.requestTimeoutMs));
            promise.adaptErrorResult(result);
        }
        return delay;
    }

    @Override
    public long getTimeout() {
        return this.requestTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(UnbindRequest unbindRequest, boolean isDisconnectNotification, Result reason) {
        List<ConnectionEventListener> tmpListeners;
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            if (unbindRequest != null) {
                notifyClose = true;
                notifyErrorOccurred = false;
                this.isClosed = true;
                tmpListeners = this.listeners;
                this.listeners = null;
                if (this.connectionInvalidReason == null) {
                    this.connectionInvalidReason = reason;
                }
            } else {
                if (this.isFailed) {
                    return;
                }
                notifyClose = false;
                notifyErrorOccurred = true;
                this.isFailed = true;
                this.failedDueToDisconnect = isDisconnectNotification;
                this.connectionInvalidReason = reason;
                tmpListeners = this.listeners;
            }
        }
        Iterator<Object> i$ = this.pendingRequests.keySet().iterator();
        while (i$.hasNext()) {
            int requestID = (Integer)i$.next();
            ResultLdapPromiseImpl<?, ?> promise = this.pendingRequests.remove(requestID);
            if (promise == null) continue;
            promise.adaptErrorResult(this.connectionInvalidReason);
        }
        if (notifyClose) {
            this.connection.write(LdapMessage.newLdapMessage(this.nextMsgId.getAndIncrement(), (byte)66, unbindRequest), new EmptyCompletionHandler(){

                @Override
                public void failed(Throwable throwable) {
                    this.completed((Object)null);
                }

                @Override
                public void completed(Object result) {
                    GrizzlyLdapConnection.this.factory.getTimeoutChecker().removeListener(GrizzlyLdapConnection.this);
                    GrizzlyLdapConnection.this.connection.closeSilently();
                    GrizzlyLdapConnection.this.factory.releaseTransportAndTimeoutChecker();
                }
            });
        }
        if (tmpListeners != null) {
            if (notifyErrorOccurred) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, LdapException.newLdapException(reason));
                }
            }
            if (notifyClose) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int continuePendingBindRequest(ResultLdapPromiseImpl promise) throws LdapException {
        int newMsgID = this.nextMsgId.getAndIncrement();
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnectionIsValid();
            this.pendingRequests.put(newMsgID, promise);
        }
        return newMsgID;
    }

    Options getLdapOptions() {
        return this.factory.getLdapOptions();
    }

    ResultLdapPromiseImpl<?, ?> getPendingRequest(Integer messageID) {
        return this.pendingRequests.get(messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsolicitedNotification(ExtendedResult result) {
        List<ConnectionEventListener> tmpListeners;
        Object object = this.stateLock;
        synchronized (object) {
            tmpListeners = this.listeners;
        }
        if (tmpListeners != null) {
            for (ConnectionEventListener listener : tmpListeners) {
                listener.handleUnsolicitedNotification(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installFilter(Filter filter) {
        Object object = this.stateLock;
        synchronized (object) {
            GrizzlyUtils.addFilterToConnection(filter, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTlsEnabled() {
        Object object = this.stateLock;
        synchronized (object) {
            FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
            for (Filter filter : currentFilterChain) {
                if (!(filter instanceof SSLFilter)) continue;
                return true;
            }
            return false;
        }
    }

    ResultLdapPromiseImpl<?, ?> removePendingRequest(Integer messageID) {
        return this.pendingRequests.remove(messageID);
    }

    void setBindOrStartTlsInProgress(boolean state) {
        this.bindOrStartTlsInProgress.set(state);
    }

    @Override
    public Promise<Void, LdapException> enableTls(SslOptions sslOptions) {
        final PromiseImpl<Void, LdapException> promise = PromiseImpl.create();
        EmptyCompletionHandler<SSLEngine> completionHandler = new EmptyCompletionHandler<SSLEngine>(){

            @Override
            public void completed(SSLEngine result) {
                promise.handleResult(null);
            }

            @Override
            public void failed(Throwable throwable) {
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(throwable).setDiagnosticMessage("SSL handshake failed");
                GrizzlyLdapConnection.this.connectionErrorOccurred(errorResult);
                promise.handleException(LdapException.newLdapException(errorResult));
            }
        };
        try {
            this.startTls(sslOptions, (CompletionHandler<SSLEngine>)completionHandler);
        }
        catch (IOException e) {
            completionHandler.failed(e);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTls(SslOptions sslOptions, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isTlsEnabled()) {
                throw new IllegalStateException("TLS already enabled");
            }
            SSLFilter sslFilter = new SSLFilter(DUMMY_SSL_ENGINE_CONFIGURATOR, GrizzlyUtils.newSslEngineConfiguration(sslOptions).setClientMode(true));
            this.installFilter(sslFilter);
            sslFilter.handshake(this.connection, completionHandler);
        }
    }

    private LdapException adaptRequestIOException(IOException e) {
        Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_ENCODING_ERROR).setCause(e);
        this.connectionErrorOccurred(errorResult);
        return LdapException.newLdapException(errorResult);
    }

    private void checkBindOrStartTLSInProgress() throws LdapException {
        if (this.bindOrStartTlsInProgress.get()) {
            throw LdapException.newLdapException(ResultCode.OPERATIONS_ERROR, "Bind or Start TLS operation in progress");
        }
    }

    private void checkConnectionIsValid() throws LdapException {
        if (!this.isValid0()) {
            if (this.failedDueToDisconnect) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, "Connection closed by server");
            }
            throw LdapException.newLdapException(this.connectionInvalidReason);
        }
    }

    private void connectionErrorOccurred(Result reason) {
        this.close(null, false, reason);
    }

    private boolean isValid0() {
        return !this.isFailed && !this.isClosed;
    }

    static {
        try {
            DUMMY_SSL_ENGINE_CONFIGURATOR = new SSLEngineConfigurator(new SslContextBuilder().trustManager(TrustManagers.distrustAll()).build());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create Dummy SSL Engine Configurator", e);
        }
        logger = LocalizedLogger.getLoggerForThisClass();
    }
}

