/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.commons;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Errors;
import org.forgerock.util.i18n.LocalizableString;

public final class CommonsApi {
    public static final ApiDescription COMMONS_API_DESCRIPTION = CommonsApi.buildCommonsApi();
    private static final String BASE_ERRORS_REF = "frapi:common#/errors/";
    public static final String BAD_REQUEST_REF = "frapi:common#/errors/badRequest";
    public static final String UNAUTHORIZED_REF = "frapi:common#/errors/unauthorized";
    public static final String PAYMENT_REQUIRED_REF = "frapi:common#/errors/paymentRequired";
    public static final String FORBIDDEN_REF = "frapi:common#/errors/forbidden";
    public static final String NOT_FOUND_REF = "frapi:common#/errors/notFound";
    public static final String METHOD_NOT_ALLOWED_REF = "frapi:common#/errors/methodNotAllowed";
    public static final String NOT_ACCEPTABLE_REF = "frapi:common#/errors/notAcceptable";
    public static final String PROXY_AUTH_REQUIRED_REF = "frapi:common#/errors/proxyAuthRequired";
    public static final String REQUEST_TIMEOUT_REF = "frapi:common#/errors/requestTimeout";
    public static final String CONFLICT_REF = "frapi:common#/errors/conflict";
    public static final String GONE_REF = "frapi:common#/errors/gone";
    public static final String LENGTH_REQUIRED_REF = "frapi:common#/errors/lengthRequired";
    public static final String VERSION_MISMATCH_REF = "frapi:common#/errors/versionMismatch";
    public static final String PRECONDITION_FAILED_REF = "frapi:common#/errors/preconditionFailed";
    public static final String REQUEST_ENTITY_TOO_LARGE_REF = "frapi:common#/errors/requestEntityTooLarge";
    public static final String REQUEST_URI_TOO_LARGE_REF = "frapi:common#/errors/requestUriTooLarge";
    public static final String UNSUPPORTED_MEDIA_TYPE_REF = "frapi:common#/errors/unsupportedMediaType";
    public static final String RANGE_NOT_SATISFIABLE_REF = "frapi:common#/errors/rangeNotSatisfiable";
    public static final String EXPECTATION_FAILED_REF = "frapi:common#/errors/expectationFailed";
    public static final String VERSION_REQUIRED_REF = "frapi:common#/errors/versionRequired";
    public static final String PRECONDITION_REQUIRED_REF = "frapi:common#/errors/preconditionRequired";
    public static final String INTERNAL_SERVER_ERROR_REF = "frapi:common#/errors/internalServerError";
    public static final String NOT_SUPPORTED_REF = "frapi:common#/errors/notSupported";
    public static final String BAD_GATEWAY_REF = "frapi:common#/errors/badGateway";
    public static final String UNAVAILABLE_REF = "frapi:common#/errors/unavailable";
    public static final String GATEWAY_TIMEOUT_REF = "frapi:common#/errors/gatewayTimeout";
    public static final String HTTP_VERSION_NOT_SUPPORTED_REF = "frapi:common#/errors/httpVersionNotSupported";

    private static ApiDescription buildCommonsApi() {
        Errors.Builder commonErrors = org.forgerock.api.models.Errors.errors();
        for (Errors error : Errors.values()) {
            commonErrors.put(error.camelCaseName, error.toApiError());
        }
        return ApiDescription.apiDescription().id("frapi:common").description(CommonsApi.i18n("commonApi.description")).version("1.0.0").errors(commonErrors.build()).build();
    }

    private static LocalizableString i18n(String translationKey) {
        String value = "i18n:org/forgerock/api/commons/frapiCommons#" + translationKey;
        return new LocalizableString(value, CommonsApi.class.getClassLoader());
    }

    private CommonsApi() {
    }

    public static enum Errors {
        BAD_REQUEST(400, "badRequest"),
        UNAUTHORIZED(401, "unauthorized"),
        PAYMENT_REQUIRED(402, "paymentRequired"),
        FORBIDDEN(403, "forbidden"),
        NOT_FOUND(404, "notFound"),
        METHOD_NOT_ALLOWED(405, "methodNotAllowed"),
        NOT_ACCEPTABLE(406, "notAcceptable"),
        PROXY_AUTH_REQUIRED(407, "proxyAuthRequired"),
        REQUEST_TIMEOUT(408, "requestTimeout"),
        CONFLICT(409, "conflict"),
        GONE(410, "gone"),
        LENGTH_REQUIRED(411, "lengthRequired"),
        VERSION_MISMATCH(412, "versionMismatch"),
        PRECONDITION_FAILED(412, "preconditionFailed"),
        REQUEST_ENTITY_TOO_LARGE(413, "requestEntityTooLarge"),
        REQUEST_URI_TOO_LARGE(414, "requestUriTooLarge"),
        UNSUPPORTED_MEDIA_TYPE(415, "unsupportedMediaType"),
        RANGE_NOT_SATISFIABLE(416, "rangeNotSatisfiable"),
        EXPECTATION_FAILED(417, "expectationFailed"),
        VERSION_REQUIRED(428, "versionRequired"),
        PRECONDITION_REQUIRED(428, "preconditionRequired"),
        INTERNAL_SERVER_ERROR(500, "internalServerError"),
        NOT_SUPPORTED(501, "notSupported"),
        BAD_GATEWAY(502, "badGateway"),
        UNAVAILABLE(503, "unavailable"),
        GATEWAY_TIMEOUT(504, "gatewayTimeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "httpVersionNotSupported");

        private String camelCaseName;
        private String reference;
        private int code;
        private String translationKey;

        private Errors(int errorCode, String camelCaseName) {
            this.code = errorCode;
            this.camelCaseName = camelCaseName;
            this.reference = CommonsApi.BASE_ERRORS_REF + camelCaseName;
            this.translationKey = "error." + camelCaseName + ".description";
        }

        public String getReference() {
            return this.reference;
        }

        private ApiError toApiError() {
            return ApiError.apiError().code(this.code).description(CommonsApi.i18n(this.translationKey)).build();
        }
    }
}

