/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;

public final class Notification<T> {
    final Object value;
    static final Notification<Object> COMPLETE = new Notification(null);

    private Notification(Object value) {
        this.value = value;
    }

    public boolean isOnComplete() {
        return this.value == null;
    }

    public boolean isOnError() {
        return NotificationLite.isError(this.value);
    }

    public boolean isOnNext() {
        Object o = this.value;
        return o != null && !NotificationLite.isError(o);
    }

    public T getValue() {
        Object o = this.value;
        if (o != null && !NotificationLite.isError(o)) {
            return (T)this.value;
        }
        return null;
    }

    public Throwable getError() {
        Object o = this.value;
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Notification) {
            Notification n = (Notification)obj;
            return ObjectHelper.equals(this.value, n.value);
        }
        return false;
    }

    public int hashCode() {
        Object o = this.value;
        return o != null ? o.hashCode() : 0;
    }

    public String toString() {
        Object o = this.value;
        if (o == null) {
            return "OnCompleteNotification";
        }
        if (NotificationLite.isError(o)) {
            return "OnErrorNotification[" + NotificationLite.getError(o) + "]";
        }
        return "OnNextNotification[" + this.value + "]";
    }

    public static <T> Notification<T> createOnNext(T value) {
        ObjectHelper.requireNonNull(value, "value is null");
        return new Notification<T>(value);
    }

    public static <T> Notification<T> createOnError(Throwable error) {
        ObjectHelper.requireNonNull(error, "error is null");
        return new Notification<T>(NotificationLite.error(error));
    }

    public static <T> Notification<T> createOnComplete() {
        return COMPLETE;
    }
}

