/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;

public final class SignatureUtil {
    private SignatureUtil() {
    }

    public static SignatureUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public byte[] sign(PrivateKey privateKey, String algorithm, String message) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(message.getBytes());
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(MessageFormat.format("Could not get Signature instance with the algorithm: {0}", algorithm), e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Invalid key", e);
        }
    }

    public boolean verify(X509Certificate certificate, String algorithm, String message, byte[] signatureData) throws SignatureException {
        return this.verify(certificate.getPublicKey(), algorithm, message, signatureData);
    }

    public boolean verify(PublicKey publicKey, String algorithm, String message, byte[] signatureData) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            signature.update(message.getBytes());
            return signature.verify(signatureData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(MessageFormat.format("Could not get Signature instance with the algorithm: {0}", algorithm), e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Invalid key", e);
        }
    }

    private static final class SingletonHolder {
        private static final SignatureUtil INSTANCE = new SignatureUtil();

        private SingletonHolder() {
        }
    }
}

