/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.util.Factory;

public class LazyList<E>
implements List<E> {
    private List<E> list;
    protected Factory<List<E>> factory;

    protected LazyList() {
    }

    public LazyList(Factory<List<E>> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<E> lazy() {
        if (this.list == null) {
            LazyList lazyList = this;
            synchronized (lazyList) {
                if (this.list == null) {
                    this.list = this.factory.newInstance();
                }
            }
        }
        return this.list;
    }

    @Override
    public int size() {
        return this.lazy().size();
    }

    @Override
    public boolean isEmpty() {
        return this.lazy().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.lazy().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.lazy().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.lazy().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.lazy().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.lazy().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.lazy().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.lazy().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.lazy().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.lazy().addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.lazy().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.lazy().retainAll(c);
    }

    @Override
    public void clear() {
        this.lazy().clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.lazy().equals(o);
    }

    @Override
    public int hashCode() {
        return this.lazy().hashCode();
    }

    @Override
    public E get(int index) {
        return this.lazy().get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.lazy().set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.lazy().add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.lazy().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.lazy().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lazy().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.lazy().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.lazy().listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.lazy().subList(fromIndex, toIndex);
    }
}

