/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityResponseControl;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class SaslPlainStrategy
implements AuthenticationStrategy {
    private final ConnectionFactory connectionFactory;
    private final Function<String, String, LdapException> formatter;

    SaslPlainStrategy(ConnectionFactory connectionFactory, final Schema schema, final String authcIdTemplate) {
        this.connectionFactory = Reject.checkNotNull(connectionFactory, "connectionFactory cannot be null");
        Reject.checkNotNull(schema, "schema cannot be null");
        Reject.checkNotNull(authcIdTemplate, "authcIdTemplate cannot be null");
        this.formatter = authcIdTemplate.startsWith("dn:") ? new Function<String, String, LdapException>(){

            @Override
            public String apply(String value) throws LdapException {
                try {
                    return Dn.format(authcIdTemplate, schema, value).toString();
                }
                catch (LocalizedIllegalArgumentException e) {
                    throw LdapException.newLdapException(ResultCode.INVALID_DN_SYNTAX, e.getMessageObject(), e);
                }
            }
        } : new Function<String, String, LdapException>(){

            @Override
            public String apply(String value) throws LdapException {
                return String.format(authcIdTemplate, value);
            }
        };
    }

    @Override
    public Promise<SecurityContext, LdapException> authenticate(final String username, final String password, final Context parentContext) {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.connectionFactory.getConnectionAsync().thenAsync(new AsyncFunction<Connection, SecurityContext, LdapException>(){

            @Override
            public Promise<SecurityContext, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return SaslPlainStrategy.this.doSaslPlainBind(connection, parentContext, username, password);
            }
        }).thenFinally(Utils.close(connectionHolder));
    }

    private Promise<SecurityContext, LdapException> doSaslPlainBind(Connection connection, final Context parentContext, final String authzId, String password) throws LdapException {
        final String authcId = this.formatter.apply(authzId);
        return connection.bindAsync(Requests.newPlainSaslBindRequest(authcId, password.toCharArray(), null).addControl(AuthorizationIdentityRequestControl.newControl(true))).then(new Function<BindResult, SecurityContext, LdapException>(){

            @Override
            public SecurityContext apply(BindResult result) throws LdapException {
                LinkedHashMap<String, Object> authz = new LinkedHashMap<String, Object>(2);
                try {
                    String authzDN;
                    AuthorizationIdentityResponseControl control = result.getControl(AuthorizationIdentityResponseControl.DECODER, new DecodeOptions());
                    if (control != null && (authzDN = control.getAuthorizationId()).startsWith("dn:")) {
                        authz.put("dn", authzDN.substring(3));
                    }
                }
                catch (DecodeException decodeException) {
                    // empty catch block
                }
                authz.put("id", authzId);
                return new SecurityContext(parentContext, authcId, authz);
            }
        });
    }
}

