/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.util.Collections2;
import java.util.Collections;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.messages.AbstractUnmodifiableRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

final class UnmodifiableModifyRequestImpl
extends AbstractUnmodifiableRequest<ModifyRequest>
implements ModifyRequest {
    UnmodifiableModifyRequestImpl(ModifyRequest impl) {
        super(impl);
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public ModifyRequest addModification(Modification modification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModifyRequest addModification(ModificationType type, String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Modification> getModifications() {
        Function<Modification, Modification, NeverThrowsException> function = new Function<Modification, Modification, NeverThrowsException>(){

            @Override
            public Modification apply(Modification value) {
                ModificationType type = value.getModificationType();
                Attribute attribute = Attributes.unmodifiableAttribute(value.getAttribute());
                return new Modification(type, attribute);
            }
        };
        List<Modification> unmodifiableModifications = Collections2.transformedList(((ModifyRequest)this.impl).getModifications(), function, Functions.identityFunction());
        return Collections.unmodifiableList(unmodifiableModifications);
    }

    @Override
    public Dn getName() {
        return ((ModifyRequest)this.impl).getName();
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.MODIFY;
    }

    @Override
    public ModifyRequest setName(Dn dn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModifyRequest setName(String dn) {
        throw new UnsupportedOperationException();
    }
}

