/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.util.Reject;

public final class UnknownRequest
extends AbstractProtocolOpImpl<UnknownRequest>
implements Request {
    private final byte protocolOpType;
    private final ByteString rawProtocolOp;

    UnknownRequest(byte protocolOpType, ByteString rawProtocolOp) {
        this.protocolOpType = protocolOpType;
        this.rawProtocolOp = Reject.checkNotNull(rawProtocolOp, "rawProtocolOp cannot be null");
    }

    public byte getProtocolOpType() {
        return this.protocolOpType;
    }

    public ByteString getRawProtocolOp() {
        return this.rawProtocolOp;
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.UNKNOWN;
    }

    @Override
    UnknownRequest getThis() {
        return this;
    }

    @Override
    public String toString() {
        return "UnknownRequest(protocolOpType=" + this.protocolOpType + ", rawProtocolOp=" + this.rawProtocolOp + ")";
    }
}

