/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.util.Reject;

final class SaslClients {
    private static final String SASL_LDAP_PROTOCOL = "ldap";
    private static final String UNUSED_SERVER_NAME = "unusedServerName";

    static SaslClient newAnonymousSaslClient(final String traceString) {
        return new SaslClient(){
            private volatile boolean isComplete = false;

            @Override
            public String getMechanismName() {
                return "ANONYMOUS";
            }

            @Override
            public boolean hasInitialResponse() {
                return true;
            }

            @Override
            public byte[] evaluateChallenge(byte[] challenge) {
                if (this.isComplete) {
                    return null;
                }
                this.isComplete = true;
                return traceString == null ? StaticUtils.EMPTY_BYTES : StaticUtils.getBytes(traceString);
            }

            @Override
            public boolean isComplete() {
                return this.isComplete;
            }

            @Override
            public byte[] unwrap(byte[] incoming, int offset, int len) {
                throw new IllegalStateException("SASL unwrap failed: QOP layer is not supported for SASL ANONYMOUS");
            }

            @Override
            public byte[] wrap(byte[] outgoing, int offset, int len) {
                throw new IllegalStateException("SASL wrap failed: QOP layer is not supported for SASL ANONYMOUS");
            }

            @Override
            public Object getNegotiatedProperty(String propName) {
                return null;
            }

            @Override
            public void dispose() {
            }
        };
    }

    static SaslClient newCramMd5Client(String authenticationId, char[] password) {
        Reject.ifNull(authenticationId, "authenticationId must not be null");
        Reject.ifNull((Object)password, "password must not be null");
        try {
            return Sasl.createSaslClient(new String[]{"CRAM-MD5"}, authenticationId, SASL_LDAP_PROTOCOL, UNUSED_SERVER_NAME, null, new CallbackHandlerImpl("CRAM-MD5", authenticationId, password, null));
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    static SaslClient newPlainClient(String authenticationId, char[] password, String authorizationId) {
        Reject.ifNull(authenticationId, "authenticationId must not be null");
        Reject.ifNull((Object)password, "password must not be null");
        try {
            return Sasl.createSaslClient(new String[]{"PLAIN"}, authorizationId, SASL_LDAP_PROTOCOL, UNUSED_SERVER_NAME, null, new CallbackHandlerImpl("PLAIN", authenticationId, password, null));
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    static SaslClient newExternalClient(String authorizationId) {
        try {
            return Sasl.createSaslClient(new String[]{"EXTERNAL"}, authorizationId, SASL_LDAP_PROTOCOL, UNUSED_SERVER_NAME, null, new CallbackHandlerImpl("EXTERNAL", null, null, null));
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    static SaslClient newDigestMd5Client(String serverName, String authenticationId, char[] password, String authorizationId, String realm, Map<String, ?> properties) {
        Reject.ifNull(serverName, "serverName must not be null");
        Reject.ifNull(authenticationId, "authenticationId must not be null");
        Reject.ifNull((Object)password, "password must not be null");
        try {
            return Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, authorizationId, SASL_LDAP_PROTOCOL, serverName, properties, new CallbackHandlerImpl("DIGEST-MD5", authenticationId, password, realm));
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    static SaslClient newGssapiClient(final String serverName, Subject subject, final String authorizationId, final Map<String, ?> properties) {
        Reject.ifNull(serverName, "serverName must not be null");
        Reject.ifNull(subject, "subject must not be null");
        try {
            SaslClient delegate = Subject.doAs(subject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    return Sasl.createSaslClient(new String[]{"GSSAPI"}, authorizationId, SaslClients.SASL_LDAP_PROTOCOL, serverName, properties, new CallbackHandlerImpl("GSSAPI", null, null, null));
                }
            });
            return new PrivilegedSaslClient(subject, delegate);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    private SaslClients() {
    }

    private static final class PrivilegedSaslClient
    implements SaslClient {
        private final Subject subject;
        private final SaslClient saslClient;

        private PrivilegedSaslClient(Subject subject, SaslClient saslClient) {
            this.subject = subject;
            this.saslClient = saslClient;
        }

        @Override
        public String getMechanismName() {
            return this.saslClient.getMechanismName();
        }

        @Override
        public boolean hasInitialResponse() {
            return this.saslClient.hasInitialResponse();
        }

        @Override
        public byte[] evaluateChallenge(final byte[] challenge) throws SaslException {
            try {
                return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return PrivilegedSaslClient.this.saslClient.evaluateChallenge(challenge);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof SaslException) {
                    throw (SaslException)e.getCause();
                }
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get(this.saslClient.getMechanismName(), StaticUtils.getExceptionMessage(e));
                throw new SaslException(msg.toString(), e);
            }
        }

        @Override
        public boolean isComplete() {
            return this.saslClient.isComplete();
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            return this.saslClient.unwrap(incoming, offset, len);
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            return this.saslClient.wrap(outgoing, offset, len);
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            return this.saslClient.getNegotiatedProperty(propName);
        }

        @Override
        public void dispose() throws SaslException {
            this.saslClient.dispose();
        }
    }

    private static final class CallbackHandlerImpl
    implements CallbackHandler {
        private final String saslMechanism;
        private final String authcid;
        private final char[] password;
        private final String realm;

        CallbackHandlerImpl(String saslMechanism, String authcid, char[] password, String realm) {
            this.saslMechanism = saslMechanism;
            this.authcid = authcid;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public final void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    if (this.authcid == null) continue;
                    ((NameCallback)callback).setName(this.authcid);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (this.password == null) continue;
                    ((PasswordCallback)callback).setPassword(this.password);
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback realmCallback = (RealmCallback)callback;
                    realmCallback.setText(this.realm != null ? this.realm : realmCallback.getDefaultText());
                    continue;
                }
                if (callback instanceof RealmChoiceCallback) {
                    RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)callback;
                    if (this.realm == null) {
                        realmChoiceCallback.setSelectedIndex(realmChoiceCallback.getDefaultChoice());
                    }
                    String[] choices = realmChoiceCallback.getChoices();
                    for (int i = 0; i < choices.length; ++i) {
                        String choice = choices[i];
                        if (!choice.equalsIgnoreCase(this.realm)) continue;
                        realmChoiceCallback.setSelectedIndex(i);
                    }
                    continue;
                }
                LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get(this.saslMechanism, callback);
                throw new UnsupportedCallbackException(callback, message.toString());
            }
        }
    }
}

