/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.CancelExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.Responses;

final class CancelExtendedRequestImpl
extends AbstractExtendedRequest<CancelExtendedRequest, ExtendedResult>
implements CancelExtendedRequest {
    private static final ExtendedResultDecoder<ExtendedResult> RESULT_DECODER = new ResultDecoder();
    private int requestId;

    CancelExtendedRequestImpl(CancelExtendedRequest cancelExtendedRequest) {
        super(cancelExtendedRequest);
        this.requestId = cancelExtendedRequest.getRequestId();
    }

    CancelExtendedRequestImpl(int requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getOid() {
        return "1.3.6.1.1.8";
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder(6);
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.requestId);
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public CancelExtendedRequest setRequestId(int id) {
        this.requestId = id;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CancelExtendedRequest(requestName=");
        builder.append(this.getOid());
        builder.append(", requestID=");
        builder.append(this.requestId);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }

        @Override
        public ExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<CancelExtendedRequest, ExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public CancelExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            ByteString requestValue = request.getValue();
            if (requestValue == null || requestValue.length() <= 0) {
                throw DecodeException.error(CoreMessages.ERR_EXTOP_CANCEL_NO_REQUEST_VALUE.get());
            }
            try {
                Asn1Reader reader = Asn1.getReader(requestValue);
                reader.readStartSequence();
                int idToCancel = (int)reader.readInteger();
                reader.readEndSequence();
                CancelExtendedRequestImpl newRequest = new CancelExtendedRequestImpl(idToCancel);
                for (Control control : request.getControls()) {
                    newRequest.addControl(control);
                }
                return newRequest;
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.ERR_EXTOP_CANCEL_CANNOT_DECODE_REQUEST_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }
    }
}

