/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;

public final class SslOptions {
    public static final KeyManager[] USE_JVM_KEY_MANAGER = null;
    public static final TrustManager[] USE_JVM_TRUST_MANAGER = null;
    public static final KeyManager[] DO_NOT_USE_KEY_MANAGER = new KeyManager[0];
    private static final Collection<String> SUPPORTED_PROTOCOLS;
    private static final Collection<String> SUPPORTED_CIPHER_SUITES;
    private SSLContext sslContext;
    private boolean useClientMode;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private Collection<String> enabledCipherSuites;
    private Collection<String> enabledProtocols;

    public static SSLEngine newSslEngine(SslOptions sslOptions) {
        String[] protocols;
        SSLEngine sslEngine = sslOptions.getSslContext().createSSLEngine();
        sslEngine.setUseClientMode(sslOptions.useClientMode());
        sslEngine.setNeedClientAuth(sslOptions.needClientAuth());
        sslEngine.setWantClientAuth(sslOptions.wantClientAuth());
        String[] cipherSuites = sslOptions.getEnabledCipherSuites();
        if (cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(cipherSuites);
        }
        if ((protocols = sslOptions.getEnabledProtocols()) != null) {
            sslEngine.setEnabledProtocols(protocols);
        }
        return sslEngine;
    }

    public static SslOptions newSslOptions(SSLContext sslContext) {
        return new SslOptions(sslContext);
    }

    public static Collection<String> getSupportedCipherSuites() {
        return SUPPORTED_CIPHER_SUITES;
    }

    public static Collection<String> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public static SslOptions copyOfSslOptions(SslOptions sslOptions) {
        return new SslOptions(sslOptions);
    }

    public static SslOptions newDefaultSslOptions() throws NoSuchAlgorithmException {
        return new SslOptions(SSLContext.getDefault());
    }

    private SslOptions(SslOptions sslOptions) {
        this.sslContext = sslOptions.getSslContext();
        this.useClientMode = sslOptions.useClientMode();
        this.wantClientAuth = sslOptions.wantClientAuth();
        this.needClientAuth = sslOptions.needClientAuth();
        this.enabledCipherSuites = SslOptions.asListOrNull(sslOptions.getEnabledCipherSuites());
        this.enabledProtocols = SslOptions.asListOrNull(sslOptions.getEnabledProtocols());
    }

    private static Collection<String> asListOrNull(String[] src) {
        return src != null ? Arrays.asList(src) : null;
    }

    private SslOptions(SSLContext sslContext) {
        this.setSslContext(sslContext);
    }

    public boolean needClientAuth() {
        return this.needClientAuth;
    }

    public boolean wantClientAuth() {
        return this.wantClientAuth;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols == null ? null : this.enabledProtocols.toArray(new String[0]);
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites == null ? null : this.enabledCipherSuites.toArray(new String[0]);
    }

    public boolean useClientMode() {
        return this.useClientMode;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SslOptions setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SslOptions useClientMode(boolean useClientMode) {
        this.useClientMode = useClientMode;
        return this;
    }

    public SslOptions needClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public SslOptions wantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    public SslOptions enabledCipherSuites(Collection<String> cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
        return this;
    }

    public SslOptions setEnabledCipherSuites(String ... cipherSuites) {
        return this.enabledCipherSuites(SslOptions.asListOrNull(cipherSuites));
    }

    public SslOptions enabledProtocols(Collection<String> protocols) {
        this.enabledProtocols = protocols;
        return this;
    }

    public SslOptions setEnabledProtocols(String ... protocols) {
        return this.enabledProtocols(SslOptions.asListOrNull(protocols));
    }

    static {
        SSLParameters supportedSSLParameters = null;
        try {
            supportedSSLParameters = SSLContext.getDefault().getSupportedSSLParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (supportedSSLParameters != null) {
            SUPPORTED_PROTOCOLS = Arrays.asList(supportedSSLParameters.getProtocols());
            SUPPORTED_CIPHER_SUITES = Arrays.asList(supportedSSLParameters.getCipherSuites());
        } else {
            SUPPORTED_PROTOCOLS = Collections.emptyList();
            SUPPORTED_CIPHER_SUITES = Collections.emptyList();
        }
    }
}

