/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.forgerock.opendj.ldap.AbstractEntry;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;

public final class AttributeFilter {
    private boolean includeAllOperationalAttributes;
    private boolean includeAllUserAttributes;
    private boolean typesOnly;
    private Collection<AttributeDescription> requestedAttributes = Collections.emptyList();

    public AttributeFilter() {
        this.includeAllUserAttributes = true;
    }

    public AttributeFilter(Collection<String> attributeDescriptions) {
        this(attributeDescriptions, Schema.getDefaultSchema());
    }

    public AttributeFilter(Collection<String> attributeDescriptions, Schema schema) {
        if (attributeDescriptions == null || attributeDescriptions.isEmpty()) {
            this.includeAllUserAttributes = true;
        } else {
            for (String attribute : attributeDescriptions) {
                this.includeAttribute(attribute, schema);
            }
        }
    }

    public AttributeFilter(String ... attributeDescriptions) {
        this(Arrays.asList(attributeDescriptions));
    }

    public Entry filteredCopyOf(Entry entry) {
        return new LinkedHashMapEntry(this.filteredViewOf(entry));
    }

    public Entry filteredViewOf(final Entry entry) {
        return new AbstractEntry(){

            @Override
            public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Entry clearAttributes() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterable<Attribute> getAllAttributes() {
                return new Iterable<Attribute>(){
                    private boolean hasNextMustIterate = true;
                    private final Iterator<Attribute> iterator;
                    private Attribute next;
                    {
                        this.iterator = entry.getAllAttributes().iterator();
                        this.next = null;
                    }

                    @Override
                    public Iterator<Attribute> iterator() {
                        return new Iterator<Attribute>(){

                            @Override
                            public boolean hasNext() {
                                if (!hasNextMustIterate) {
                                    return next != null;
                                }
                                hasNextMustIterate = false;
                                while (iterator.hasNext()) {
                                    Attribute attribute = (Attribute)iterator.next();
                                    AttributeDescription ad = attribute.getAttributeDescription();
                                    AttributeDescription requestedAd = this.getBestMatch(ad);
                                    if (requestedAd == null) continue;
                                    next = Attributes.renameAttribute(attribute, requestedAd);
                                    return true;
                                }
                                next = null;
                                return false;
                            }

                            @Override
                            public Attribute next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                hasNextMustIterate = true;
                                return AttributeFilter.this.filterAttribute(next);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    public String toString() {
                        return Iterables.toString(this);
                    }
                };
            }

            @Override
            public Attribute getAttribute(AttributeDescription attributeDescription) {
                Attribute attribute = entry.getAttribute(attributeDescription);
                if (attribute == null) {
                    return null;
                }
                AttributeDescription requestedAttribute = this.getBestMatch(attributeDescription);
                if (requestedAttribute == null) {
                    return null;
                }
                return AttributeFilter.this.filterAttribute(Attributes.renameAttribute(attribute, requestedAttribute));
            }

            private AttributeDescription getBestMatch(AttributeDescription attributeDescription) {
                if (AttributeFilter.this.isMatchedByIncludeAll(attributeDescription.getAttributeType())) {
                    for (AttributeDescription requestedAttribute : AttributeFilter.this.requestedAttributes) {
                        if (!attributeDescription.equals(requestedAttribute)) continue;
                        return requestedAttribute;
                    }
                    return attributeDescription;
                }
                boolean isFound = false;
                for (AttributeDescription requestedAttribute : AttributeFilter.this.requestedAttributes) {
                    if (attributeDescription.equals(requestedAttribute)) {
                        return requestedAttribute;
                    }
                    if (isFound || !attributeDescription.isSubTypeOf(requestedAttribute)) continue;
                    isFound = true;
                }
                return isFound ? attributeDescription : null;
            }

            @Override
            public int getAttributeCount() {
                return Iterables.size(this.getAllAttributes());
            }

            @Override
            public Dn getName() {
                return entry.getName();
            }

            @Override
            public Entry setName(Dn dn) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public AttributeFilter includeAllOperationalAttributes(boolean include) {
        this.includeAllOperationalAttributes = include;
        return this;
    }

    public AttributeFilter includeAllUserAttributes(boolean include) {
        this.includeAllUserAttributes = include;
        return this;
    }

    public AttributeFilter includeAttribute(AttributeDescription attributeDescription) {
        this.allocateRequestedAttributes();
        this.requestedAttributes.add(attributeDescription);
        return this;
    }

    public AttributeFilter includeAttribute(String attributeDescription) {
        return this.includeAttribute(attributeDescription, Schema.getDefaultSchema());
    }

    public AttributeFilter includeAttribute(String attributeDescription, Schema schema) {
        return this.includeAttribute(attributeDescription, schema, true);
    }

    public AttributeFilter includeAttribute(String attributeDescription, Schema schema, boolean includeAttributesFromSuperiors) {
        switch (attributeDescription) {
            case "*": {
                this.includeAllUserAttributes = true;
                return this;
            }
            case "+": {
                this.includeAllOperationalAttributes = true;
                return this;
            }
            case "1.1": {
                return this;
            }
        }
        if (attributeDescription.startsWith("@") && attributeDescription.length() > 1) {
            String objectClassName = attributeDescription.substring(1);
            ObjectClass objectClass = schema.getObjectClass(objectClassName);
            if (!objectClass.isPlaceHolder()) {
                Set<AttributeType> optionalAttributes;
                Set<AttributeType> requiredAttributes;
                this.allocateRequestedAttributes();
                if (includeAttributesFromSuperiors) {
                    requiredAttributes = objectClass.getRequiredAttributes();
                    optionalAttributes = objectClass.getOptionalAttributes();
                } else {
                    requiredAttributes = objectClass.getDeclaredRequiredAttributes();
                    optionalAttributes = objectClass.getDeclaredOptionalAttributes();
                }
                for (AttributeType at : requiredAttributes) {
                    this.requestedAttributes.add(AttributeDescription.create(at));
                }
                for (AttributeType at : optionalAttributes) {
                    this.requestedAttributes.add(AttributeDescription.create(at));
                }
            }
        } else {
            this.allocateRequestedAttributes();
            this.requestedAttributes.add(AttributeDescription.valueOf(attributeDescription, schema));
        }
        return this;
    }

    public boolean matchesAllAttributes() {
        return this.includeAllUserAttributes && this.includeAllOperationalAttributes;
    }

    public boolean matchesAllUserAttributes() {
        return this.includeAllUserAttributes;
    }

    public boolean matchesAllOperationalAttributes() {
        return this.includeAllOperationalAttributes;
    }

    public boolean matchesAnyAttributes() {
        return this.includeAllUserAttributes || this.includeAllOperationalAttributes || !this.requestedAttributes.isEmpty();
    }

    public boolean matchesAttribute(AttributeDescription attributeDescription) {
        if (this.isMatchedByIncludeAll(attributeDescription.getAttributeType())) {
            return true;
        }
        for (AttributeDescription requestedAttribute : this.requestedAttributes) {
            if (!attributeDescription.isSubTypeOf(requestedAttribute)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchedByIncludeAll(AttributeType attributeType) {
        return attributeType.isOperational() ? this.includeAllOperationalAttributes : this.includeAllUserAttributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeAllUserAttributes) {
            builder.append('*');
        }
        if (this.includeAllOperationalAttributes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('+');
        }
        for (AttributeDescription requestedAttribute : this.requestedAttributes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(requestedAttribute);
        }
        return builder.length() == 0 ? "1.1" : builder.toString();
    }

    public AttributeFilter typesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
        return this;
    }

    private void allocateRequestedAttributes() {
        if (this.requestedAttributes.isEmpty()) {
            this.requestedAttributes = new ArrayList<AttributeDescription>();
        }
    }

    private Attribute filterAttribute(Attribute attribute) {
        return this.typesOnly ? Attributes.emptyAttribute(attribute.getAttributeDescription()) : attribute;
    }
}

