/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.forgerock.opendj.grizzly.AbstractOptionalFilter;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.util.annotations.VisibleForTesting;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

final class StartTlsFilter
extends AbstractOptionalFilter {
    StartTlsFilter() {
        this(new SSLFilter());
    }

    @VisibleForTesting
    StartTlsFilter(Filter filter) {
        super(filter);
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() != ActivateStartTlsEvent.TYPE) {
            return ctx.getInvokeAction();
        }
        ActivateStartTlsEvent startTlsEvent = (ActivateStartTlsEvent)event;
        SSLEngine sslEngine = SslOptions.newSslEngine(startTlsEvent.sslOptions);
        sslEngine.beginHandshake();
        SSLUtils.setSSLEngine(ctx.getConnection(), sslEngine);
        this.activateFilterAfterNextWrittenMessage();
        return ctx.getStopAction();
    }

    static final class ActivateStartTlsEvent
    implements FilterChainEvent {
        private static final Object TYPE = ActivateStartTlsEvent.class;
        @VisibleForTesting
        final SslOptions sslOptions;

        ActivateStartTlsEvent(SslOptions sslOptions) {
            this.sslOptions = sslOptions;
        }

        @Override
        public Object type() {
            return TYPE;
        }
    }
}

