/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.ObjectValidatorFactory;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.Validator;

public class ArrayTypeValidator
extends Validator {
    private int minItems = -1;
    private int maxItems = -1;
    private boolean uniqueItems = false;
    private boolean additionalItems = true;
    private List<Validator> tupleValidators = null;
    private Validator singleValidator = null;
    private Validator additionalItemsValidator = null;

    public ArrayTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        int count = 0;
        for (Map.Entry<String, Object> e : schema.entrySet()) {
            block10: {
                List<String> newPointer;
                block13: {
                    block15: {
                        block14: {
                            block12: {
                                block11: {
                                    block8: {
                                        block9: {
                                            if (!"uniqueItems".equals(e.getKey())) break block8;
                                            if (!(e.getValue() instanceof Boolean)) break block9;
                                            this.uniqueItems = (Boolean)e.getValue();
                                            break block10;
                                        }
                                        if (!(e.getValue() instanceof String)) break block10;
                                        this.uniqueItems = Boolean.parseBoolean((String)e.getValue());
                                        break block10;
                                    }
                                    if (!"minItems".equals(e.getKey())) break block11;
                                    if (e.getValue() instanceof Number) {
                                        this.minItems = Math.max(((Number)e.getValue()).intValue(), -1);
                                    }
                                    break block10;
                                }
                                if (!"maxItems".equals(e.getKey())) break block12;
                                if (e.getValue() instanceof Number) {
                                    this.maxItems = Math.max(((Number)e.getValue()).intValue(), this.minItems);
                                }
                                break block10;
                            }
                            if (!"additionalItems".equals(e.getKey())) break block13;
                            if (!(e.getValue() instanceof Boolean)) break block14;
                            this.additionalItems = (Boolean)e.getValue();
                            break block10;
                        }
                        if (!(e.getValue() instanceof String)) break block15;
                        this.additionalItems = Boolean.parseBoolean((String)e.getValue());
                        break block10;
                    }
                    if (!(e.getValue() instanceof Map)) break block10;
                    newPointer = this.newList(jsonPointer, "additionalItems", Integer.toString(count));
                    this.additionalItemsValidator = ObjectValidatorFactory.getTypeValidator((Map)e.getValue(), newPointer);
                    break block10;
                }
                if ("items".equals(e.getKey())) {
                    newPointer = this.newList(jsonPointer, "items", Integer.toString(count));
                    if (e.getValue() instanceof Map) {
                        this.singleValidator = ObjectValidatorFactory.getTypeValidator((Map)e.getValue(), newPointer);
                    } else if (e.getValue() instanceof List) {
                        List arrayTypes = (List)e.getValue();
                        this.tupleValidators = new ArrayList<Validator>(arrayTypes.size());
                        for (Object o : arrayTypes) {
                            if (!(o instanceof Map)) continue;
                            this.tupleValidators.add(ObjectValidatorFactory.getTypeValidator((Map)o, newPointer));
                        }
                    }
                }
            }
            ++count;
        }
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) {
        if (node instanceof List) {
            List nodeValue = (List)node;
            if (this.minItems > -1 && nodeValue.size() < this.minItems) {
                handler.error(new ValidationException("minItems error"));
            }
            if (this.maxItems > -1 && nodeValue.size() > this.maxItems) {
                handler.error(new ValidationException("maxItems error"));
            }
            this.checkUniqueItems(nodeValue, at, handler);
            if (null != this.singleValidator) {
                for (int i = 0; i < nodeValue.size(); ++i) {
                    this.singleValidator.validate(nodeValue.get(i), this.getPath(at, Integer.toString(i)), handler);
                }
            } else if (null != this.tupleValidators) {
                if (this.tupleValidators.size() > nodeValue.size()) {
                    handler.error(new ValidationException("Array has less item then expected", this.getPath(at, null)));
                } else if (!this.additionalItems && this.tupleValidators.size() < nodeValue.size()) {
                    handler.error(new ValidationException("Array can not have additional item(s)", this.getPath(at, null)));
                } else {
                    for (int i = 0; i < nodeValue.size(); ++i) {
                        Validator v;
                        Validator validator = v = i < this.tupleValidators.size() ? this.tupleValidators.get(i) : this.additionalItemsValidator;
                        if (null == v) continue;
                        v.validate(nodeValue.get(i), this.getPath(at, Integer.toString(i)), handler);
                    }
                }
            }
        } else if (null != node) {
            handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null), node));
        } else if (this.required) {
            handler.error(new ValidationException("Required property violation at {}", this.getPath(at, null)));
        }
    }

    private void checkUniqueItems(List<Object> nodeValue, JsonPointer at, ErrorHandler handler) {
        HashSet<Object> set;
        if (this.uniqueItems && nodeValue.size() > 1 && (set = new HashSet<Object>(nodeValue)).size() < nodeValue.size()) {
            handler.error(new ValidationException("The items in the array must be unique", this.getPath(at, null)));
        }
    }

    @Override
    protected void collectAllValidators(Collection<Validator> results) {
        results.add(this);
        ArrayTypeValidator.collectAllValidators(results, this.tupleValidators);
        if (this.singleValidator != null) {
            this.singleValidator.collectAllValidators(results);
        }
        if (this.additionalItemsValidator != null) {
            this.additionalItemsValidator.collectAllValidators(results);
        }
    }
}

