/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public final class FilterChain
implements RequestHandler,
Describable<ApiDescription, Request> {
    private final List<Filter> filters = new CopyOnWriteArrayList<Filter>();
    private volatile RequestHandler target;

    public FilterChain(RequestHandler target) {
        this.target = Reject.checkNotNull(target, "Cannot create FilterChain with null target RequestHandler");
    }

    public FilterChain(RequestHandler target, Collection<Filter> filters) {
        this.target = Reject.checkNotNull(target, "Cannot create FilterChain with null target RequestHandler");
        this.filters.addAll(filters);
    }

    public FilterChain(RequestHandler target, Filter ... filters) {
        this.target = Reject.checkNotNull(target, "Cannot create FilterChain with null target RequestHandler");
        this.filters.addAll(Arrays.asList(filters));
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public RequestHandler getTarget() {
        return this.target;
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return new Cursor().handleAction(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return new Cursor().handleCreate(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return new Cursor().handleDelete(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return new Cursor().handlePatch(context, request);
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return new Cursor().handleQuery(context, request, handler);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return new Cursor().handleRead(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return new Cursor().handleUpdate(context, request);
    }

    @Override
    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        return this.target instanceof Describable ? ((Describable)((Object)this.target)).api(producer) : null;
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        if (this.target instanceof Describable) {
            return (ApiDescription)((Describable)((Object)this.target)).handleApiRequest(context, request);
        }
        throw new UnsupportedOperationException("Target RequestHandler " + this.target.getClass().getName() + " is not describable");
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        if (this.target instanceof Describable) {
            ((Describable)((Object)this.target)).addDescriptorListener(listener);
        }
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.target instanceof Describable) {
            ((Describable)((Object)this.target)).removeDescriptorListener(listener);
        }
    }

    public FilterChain setTarget(RequestHandler target) {
        this.target = Reject.checkNotNull(target, "Cannot set target RequestHandler to null value");
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.filters.toString());
        builder.append(" -> ");
        builder.append(this.target.toString());
        return builder.toString();
    }

    private final class Cursor
    implements RequestHandler,
    Describable<ApiDescription, Request> {
        private final int pos;
        private final Filter[] snapshot;

        private Cursor() {
            this(filterChain.filters.toArray(new Filter[0]), 0);
        }

        private Cursor(Filter[] snapshot, int pos) {
            this.snapshot = snapshot;
            this.pos = pos;
        }

        @Override
        public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
            if (this.hasNext()) {
                return this.get().filterAction(context, request, this.next());
            }
            return FilterChain.this.target.handleAction(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
            if (this.hasNext()) {
                return this.get().filterCreate(context, request, this.next());
            }
            return FilterChain.this.target.handleCreate(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
            if (this.hasNext()) {
                return this.get().filterDelete(context, request, this.next());
            }
            return FilterChain.this.target.handleDelete(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
            if (this.hasNext()) {
                return this.get().filterPatch(context, request, this.next());
            }
            return FilterChain.this.target.handlePatch(context, request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
            if (this.hasNext()) {
                return this.get().filterQuery(context, request, handler, this.next());
            }
            return FilterChain.this.target.handleQuery(context, request, handler);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
            if (this.hasNext()) {
                return this.get().filterRead(context, request, this.next());
            }
            return FilterChain.this.target.handleRead(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
            if (this.hasNext()) {
                return this.get().filterUpdate(context, request, this.next());
            }
            return FilterChain.this.target.handleUpdate(context, request);
        }

        @Override
        public ApiDescription api(ApiProducer<ApiDescription> producer) {
            throw new UnsupportedOperationException("API resolution should skip filters");
        }

        @Override
        public ApiDescription handleApiRequest(Context context, Request request) {
            throw new UnsupportedOperationException("API resolution should skip filters");
        }

        @Override
        public void addDescriptorListener(Describable.Listener listener) {
            throw new UnsupportedOperationException("API resolution should skip filters");
        }

        @Override
        public void removeDescriptorListener(Describable.Listener listener) {
            throw new UnsupportedOperationException("API resolution should skip filters");
        }

        private Filter get() {
            return this.snapshot[this.pos];
        }

        private boolean hasNext() {
            return this.pos < this.snapshot.length;
        }

        private Cursor next() {
            return new Cursor(this.snapshot, this.pos + 1);
        }
    }
}

