/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.forgerock.http.util.Uris;

public final class Paths {
    private static final Pattern PATH_SPLIT_PATTERN = Pattern.compile("/");

    public static String urlDecode(Object value) {
        return Uris.urlDecodePathElement(value.toString());
    }

    public static String urlEncode(Object value) {
        return Uris.urlEncodePathElement(value.toString());
    }

    public static List<String> getPathElements(String rawPath) {
        List elements;
        String[] pathElements = null;
        if (rawPath != null) {
            if (rawPath.startsWith("/")) {
                rawPath = rawPath.substring(1);
            }
            if ((pathElements = PATH_SPLIT_PATTERN.split(rawPath, -1)).length == 1 && pathElements[0].isEmpty()) {
                pathElements = null;
            }
        }
        if (pathElements == null) {
            elements = Collections.emptyList();
        } else {
            ArrayList decodedElements = new ArrayList(pathElements.length);
            for (String element : pathElements) {
                decodedElements.add(Paths.urlDecode(element));
            }
            elements = decodedElements;
        }
        return Collections.unmodifiableList(elements);
    }

    public static String joinPath(List<String> elements) {
        if (elements == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (String element : elements) {
            if (s.length() > 0) {
                s.append("/");
            }
            s.append(Paths.urlEncode(element));
        }
        return s.toString();
    }

    public static String addTrailingSlash(String rawPath) {
        return rawPath.endsWith("/") ? rawPath : rawPath.concat("/");
    }

    public static String removeTrailingSlash(String rawPath) {
        return rawPath.endsWith("/") ? rawPath.substring(0, rawPath.length() - 1) : rawPath;
    }

    public static String addLeadingSlash(String rawPath) {
        return rawPath.startsWith("/") ? rawPath : "/" + rawPath;
    }

    public static String removeLeadingSlash(String rawPath) {
        return rawPath.startsWith("/") ? rawPath.substring(1) : rawPath;
    }

    private Paths() {
    }
}

