/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.net.URI;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.util.Json;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiRequestFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiRequestFilter.class);
    public static final String API_PARAMETER = "_api";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule(new Json.LocalizableStringModule());

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        if (!(next instanceof Describable) || !request.getForm().containsKey(API_PARAMETER)) {
            return next.handle(context, request);
        }
        try {
            Swagger result = (Swagger)((Describable)((Object)next)).handleApiRequest(context, request);
            if (result == null) {
                return Response.newResponsePromise(new Response(Status.NOT_IMPLEMENTED));
            }
            result = this.setUriDetailsIfNotPresent(request, context, result);
            ObjectWriter writer = Json.makeLocalizingObjectWriter(OBJECT_MAPPER, request);
            Response chfResponse = new Response(Status.OK).setEntity(writer.writeValueAsBytes(result));
            chfResponse.getHeaders().put("Content-Type", (Object)"application/json; charset=UTF-8");
            return Response.newResponsePromise(chfResponse);
        }
        catch (IllegalStateException e) {
            logger.trace("Cannot route {} to an acceptable handler", (Object)request.getUri(), (Object)e);
            return Response.newResponsePromise(Responses.newNotFound());
        }
        catch (JsonProcessingException | RuntimeException | MalformedHeaderException e) {
            logger.error("Exception caught while generating OpenAPI descriptor", e);
            return Response.newResponsePromise(Responses.newInternalServerError(e));
        }
    }

    protected Swagger setUriDetailsIfNotPresent(Request request, Context context, Swagger descriptor) {
        if (context.containsContext(UriRouterContext.class)) {
            UriRouterContext uriRouterContext = context.asContext(UriRouterContext.class);
            URI originalUri = uriRouterContext.getOriginalUri();
            if (descriptor.getBasePath() == null || descriptor.getBasePath().trim().isEmpty()) {
                descriptor.setBasePath(uriRouterContext.getBaseUri());
            }
            if (descriptor.getSchemes() == null || descriptor.getSchemes().isEmpty()) {
                descriptor.addScheme(Scheme.forValue(originalUri.getScheme()));
            }
            if (descriptor.getHost() == null || descriptor.getHost().trim().isEmpty()) {
                String host = originalUri.getHost();
                if (originalUri.getPort() != 80 && originalUri.getPort() != 443) {
                    host = host + ":" + originalUri.getPort();
                }
                descriptor.setHost(host);
            }
        }
        return descriptor;
    }
}

