/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import java.util.Arrays;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.OverflowException;

final class MemoryBuffer
implements Buffer {
    byte[] data;
    private final int limit;
    private int length = 0;

    MemoryBuffer(int initial, int limit) {
        this.data = new byte[initial];
        this.limit = limit;
    }

    @Override
    public byte read(int pos) throws IOException {
        this.notClosed();
        if (pos < this.data.length) {
            return this.data[pos];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int read(int pos, byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int n = 0;
        if (pos < this.length) {
            n = Math.min(len, this.length - pos);
            System.arraycopy(this.data, pos, b, off, n);
        }
        return n;
    }

    @Override
    public void append(byte b) throws IOException {
        this.notClosed();
        int end = this.length + 1;
        this.growBufferIfNecessary(end);
        this.data[this.length] = b;
        this.length = end;
    }

    @Override
    public void append(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int end = this.length + len;
        this.growBufferIfNecessary(end);
        System.arraycopy(b, off, this.data, this.length, len);
        this.length = end;
    }

    private void growBufferIfNecessary(int end) throws OverflowException {
        if (end > this.limit) {
            throw new OverflowException();
        }
        if (this.data.length < end) {
            this.data = Arrays.copyOf(this.data, Math.max(end, Math.min(this.limit, this.data.length << 1)));
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void close() {
        this.data = null;
    }

    private void notClosed() throws IOException {
        if (this.data == null) {
            throw new IOException("buffer is closed");
        }
    }
}

