/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.BranchingStreamWrapper;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.ByteArrayBranchingStream;
import org.forgerock.http.io.FileBuffer;
import org.forgerock.http.io.MemoryBuffer;
import org.forgerock.http.io.TemporaryBuffer;
import org.forgerock.util.Factory;

public final class IO {
    public static final int DEFAULT_TMP_INIT_LENGTH = 8192;
    public static final int DEFAULT_TMP_MEMORY_LIMIT = 65536;
    public static final int DEFAULT_TMP_FILE_LIMIT = 0x40000000;
    private static final int BUF_SIZE = 8192;
    private static final InputStream NULL_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private static final int BUF_POOL_INITIAL_SIZE = 32;
    private static final Queue<byte[]> BYTE_BUF_POOL = new ConcurrentLinkedQueue<byte[]>();
    private static final Queue<char[]> CHAR_BUF_POOL = new ConcurrentLinkedQueue<char[]>();

    public static BranchingInputStream newBranchingInputStream(byte[] bytes) {
        return new ByteArrayBranchingStream(bytes);
    }

    public static BranchingInputStream newBranchingInputStream(InputStream in, Factory<Buffer> bufferFactory) {
        return new BranchingStreamWrapper(in, bufferFactory);
    }

    public static Buffer newFileBuffer(File file, int limit) throws FileNotFoundException {
        return new FileBuffer(file, limit);
    }

    public static Buffer newMemoryBuffer(int initial, int limit) {
        return new MemoryBuffer(initial, limit);
    }

    public static Buffer newTemporaryBuffer(int initialLength, int memoryLimit, int fileLimit, File directory) {
        return new TemporaryBuffer(initialLength, memoryLimit, fileLimit, directory);
    }

    public static Factory<Buffer> newTemporaryStorage() {
        return IO.newTemporaryStorage(null);
    }

    public static Factory<Buffer> newTemporaryStorage(File directory) {
        return IO.newTemporaryStorage(directory, 8192, 65536, 0x40000000);
    }

    public static Factory<Buffer> newTemporaryStorage(File directory, int initialLength, int memoryLimit, int fileLimit) {
        return () -> IO.newTemporaryBuffer(initialLength, memoryLimit, fileLimit, directory);
    }

    public static InputStream nullInputStream() {
        return NULL_INPUT_STREAM;
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = BYTE_BUF_POOL.poll();
        if (buf == null) {
            buf = new byte[8192];
        }
        try {
            int n;
            while ((n = in.read(buf, 0, 8192)) != -1) {
                out.write(buf, 0, n);
            }
        }
        finally {
            BYTE_BUF_POOL.add(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stream(InputStream in, OutputStream out, int len) throws IOException {
        byte[] buf = BYTE_BUF_POOL.poll();
        if (buf == null) {
            buf = new byte[8192];
        }
        try {
            int remaining;
            int n;
            for (remaining = len; remaining > 0 && (n = in.read(buf, 0, Math.min(remaining, 8192))) >= 0; remaining -= n) {
                out.write(buf, 0, n);
            }
            int n2 = len - remaining;
            return n2;
        }
        finally {
            BYTE_BUF_POOL.add(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stream(Reader in, Writer out) throws IOException {
        char[] buf = CHAR_BUF_POOL.poll();
        if (buf == null) {
            buf = new char[8192];
        }
        try {
            int n;
            while ((n = in.read(buf, 0, 8192)) != -1) {
                out.write(buf, 0, n);
            }
        }
        finally {
            CHAR_BUF_POOL.add(buf);
        }
    }

    private IO() {
    }

    static {
        for (int i = 0; i < 32; ++i) {
            BYTE_BUF_POOL.add(new byte[8192]);
            CHAR_BUF_POOL.add(new char[8192]);
        }
    }
}

