/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import org.forgerock.http.io.BranchingInputStream;

final class ByteArrayBranchingStream
extends BranchingInputStream {
    private int position = 0;
    private int mark = -1;
    private byte[] data;

    ByteArrayBranchingStream(byte[] data) {
        super(null);
        this.data = data;
    }

    private ByteArrayBranchingStream(byte[] data, BranchingInputStream parent) {
        super(parent);
        this.data = data;
    }

    @Override
    public ByteArrayBranchingStream branch() {
        ByteArrayBranchingStream branch = new ByteArrayBranchingStream(this.data, this);
        branch.position = this.position;
        return branch;
    }

    @Override
    public ByteArrayBranchingStream copy() throws IOException {
        ByteArrayBranchingStream branch = new ByteArrayBranchingStream(this.data, this.parent());
        branch.position = this.position;
        return branch;
    }

    @Override
    public synchronized int read() {
        return this.position < this.data.length ? this.data[this.position++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.data.length) {
            return -1;
        }
        len = Math.min(len, this.data.length - this.position);
        System.arraycopy(this.data, this.position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        n = Math.min(n, (long)(this.data.length - this.position));
        this.position = (int)((long)this.position + n);
        return n;
    }

    @Override
    public synchronized int available() {
        return this.data.length - this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("position was not marked");
        }
        this.position = this.mark;
    }

    @Override
    public void close() {
    }
}

