/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.forgerock.api.enums.Stability;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Resource;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.i18n.LocalizableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Operation {
    private static final Logger logger = LoggerFactory.getLogger(Operation.class);
    private final LocalizableString description;
    private final String[] supportedLocales;
    @JsonProperty(value="errors")
    private final ApiError[] apiErrors;
    private final Parameter[] parameters;
    private final Stability stability;

    protected Operation(Builder builder) {
        this.description = builder.description;
        this.supportedLocales = builder.supportedLocales;
        this.stability = builder.stability;
        List apiErrors = builder.apiErrors;
        this.apiErrors = apiErrors.toArray(new ApiError[apiErrors.size()]);
        List parameters = builder.parameters;
        this.parameters = parameters.toArray(new Parameter[parameters.size()]);
    }

    public LocalizableString getDescription() {
        return this.description;
    }

    public String[] getSupportedLocales() {
        return this.supportedLocales;
    }

    public ApiError[] getApiErrors() {
        return this.apiErrors.length == 0 ? null : this.apiErrors;
    }

    public Parameter[] getParameters() {
        return this.parameters.length == 0 ? null : this.parameters;
    }

    public Stability getStability() {
        return this.stability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return Objects.equals(this.description, operation.description) && Arrays.equals(this.supportedLocales, operation.supportedLocales) && Arrays.equals(this.apiErrors, operation.apiErrors) && Arrays.equals(this.parameters, operation.parameters) && this.stability == operation.stability;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.supportedLocales, this.apiErrors, this.parameters, this.stability});
    }

    protected abstract void allocateToResource(Resource.Builder var1);

    public static abstract class Builder<T extends Builder<T>> {
        private LocalizableString description;
        private String[] supportedLocales;
        private final List<ApiError> apiErrors = new ArrayList<ApiError>();
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private Stability stability;

        protected Builder() {
        }

        protected abstract T self();

        public T description(LocalizableString description) {
            this.description = description;
            return this.self();
        }

        @JsonProperty(value="description")
        public T description(String description) {
            this.description = new LocalizableString(description);
            return this.self();
        }

        @JsonProperty(value="supportedLocales")
        public T supportedLocales(String ... supportedlocales) {
            this.supportedLocales = supportedlocales;
            return this.self();
        }

        @JsonProperty(value="errors")
        public T errors(List<ApiError> apiErrors) {
            this.apiErrors.addAll(apiErrors);
            return this.self();
        }

        public T error(ApiError apiError) {
            this.apiErrors.add(apiError);
            return this.self();
        }

        @JsonProperty(value="parameters")
        public T parameters(List<Parameter> parameters) {
            this.parameters.addAll(parameters);
            return this.self();
        }

        public T parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this.self();
        }

        @JsonProperty(value="stability")
        public T stability(Stability stability) {
            this.stability = stability;
            return this.self();
        }

        public T detailsFromAnnotation(org.forgerock.api.annotations.Operation operation, ApiDescription descriptor, Class<?> relativeType) {
            for (String ref : operation.errorRefs()) {
                if (ValidationUtil.isEmpty(ref)) {
                    logger.debug("Empty errorRefs array-element ignored on: " + relativeType.getCanonicalName());
                    continue;
                }
                this.error(ApiError.apiError().reference(Reference.reference().value(ref).build()).build());
            }
            for (org.forgerock.api.annotations.ApiError apiApiError : operation.errors()) {
                this.error(ApiError.fromAnnotation(apiApiError, descriptor, relativeType));
            }
            for (org.forgerock.api.annotations.Parameter parameter : operation.parameters()) {
                this.parameter(Parameter.fromAnnotation(relativeType, parameter));
            }
            return ((Builder)((Builder)this.description(new LocalizableString(operation.description(), relativeType))).supportedLocales(operation.locales())).stability(operation.stability());
        }
    }
}

