/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.forgerock.api.models.Schema;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class Definitions {
    private final Map<String, Schema> definitions;

    private Definitions(Builder builder) {
        this.definitions = builder.definitions;
    }

    @JsonValue
    protected Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    @JsonIgnore
    public Schema get(String name) {
        return this.definitions.get(name);
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.definitions.keySet();
    }

    public static Builder definitions() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Definitions that = (Definitions)o;
        return Objects.equals(this.definitions, that.definitions);
    }

    public int hashCode() {
        return Objects.hash(this.definitions);
    }

    public static final class Builder {
        private final Map<String, Schema> definitions = new HashMap<String, Schema>();

        private Builder() {
        }

        @JsonAnySetter
        public Builder put(String name, Schema schema) {
            if (ValidationUtil.isEmpty(name) || ValidationUtil.containsWhitespace(name)) {
                throw new IllegalArgumentException("Schema name required and may not contain whitespace, current value: '" + name + "'");
            }
            if (this.definitions.containsKey(name) && !this.definitions.get(name).equals(schema)) {
                throw new IllegalStateException("The given Schema name '" + name + "' already exists but the Schema objects are not equal");
            }
            this.definitions.put(name, Reject.checkNotNull(schema));
            return this;
        }

        public Definitions build() {
            return new Definitions(this);
        }
    }
}

