/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitInputStream
extends InputStream {
    private int bytesRead;
    private int markBytesRead;
    private final int readLimit;
    private final InputStream parentStream;

    public SizeLimitInputStream(InputStream parentStream, int readLimit) {
        this.parentStream = parentStream;
        this.readLimit = readLimit;
    }

    @Override
    public int available() throws IOException {
        int limitedAvail = this.readLimit - this.bytesRead;
        int streamAvail = this.parentStream.available();
        return limitedAvail < streamAvail ? limitedAvail : streamAvail;
    }

    @Override
    public void close() throws IOException {
        this.parentStream.close();
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public int getSizeLimit() {
        return this.readLimit;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.parentStream.mark(readlimit);
        this.markBytesRead = this.bytesRead;
    }

    @Override
    public boolean markSupported() {
        return this.parentStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.readLimit) {
            return -1;
        }
        int b = this.parentStream.read();
        if (b != -1) {
            ++this.bytesRead;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readLen;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.bytesRead >= this.readLimit) {
            return -1;
        }
        if (this.bytesRead + len > this.readLimit) {
            len = this.readLimit - this.bytesRead;
        }
        if ((readLen = this.parentStream.read(b, off, len)) > 0) {
            this.bytesRead += readLen;
        }
        return readLen;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.parentStream.reset();
        this.bytesRead = this.markBytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((long)this.bytesRead + n > (long)this.readLimit) {
            n = this.readLimit - this.bytesRead;
        }
        this.bytesRead = (int)((long)this.bytesRead + n);
        return this.parentStream.skip(n);
    }
}

