/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentGroup;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocGenerationHelper;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.TrailingArgumentsConstraints;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.util.OperatingSystem;
import com.forgerock.opendj.util.StaticUtils;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.util.Reject;

public class SubCommandArgumentParser
extends ArgumentParser {
    private static final String INDENT = "    ";
    private static final int COLUMN_ADJUST = OperatingSystem.isWindows() ? 1 : 0;
    private final Map<Argument, Collection<SubCommand>> usageGroupArguments = new HashMap<Argument, Collection<SubCommand>>();
    private final SortedMap<String, SubCommand> subCommands = new TreeMap<String, SubCommand>(String.CASE_INSENSITIVE_ORDER);
    private SubCommand defaultSubCommand;
    private boolean automaticallySelectedDefaultSubCommand;
    private SubCommand selectedSubCommand;

    public SubCommandArgumentParser(String mainClassName, LocalizableMessage toolDescription) {
        super(mainClassName, toolDescription);
    }

    public final SubCommand getSubCommand(String name) {
        return (SubCommand)this.subCommands.get(name);
    }

    public final SubCommand getSelectedSubCommand() {
        return this.selectedSubCommand;
    }

    @Override
    public final <A extends Argument> A addArgument(A argument, ArgumentGroup group) {
        String longId = argument.getLongIdentifier();
        Character shortId = argument.getShortIdentifier();
        for (SubCommand subCommand : this.subCommands.values()) {
            Argument conflictingArg;
            if (subCommand.getArgument(longId) != null) {
                throw new IllegalArgumentException(CliMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_NAME_SUBCMD_CONFLICT.get(longId, subCommand.getName()).toString());
            }
            if (shortId == null || (conflictingArg = subCommand.getArgument(shortId)) == null) continue;
            throw new IllegalArgumentException(CliMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_SHORT_ID_CONFLICT.get(shortId, longId, conflictingArg.getLongIdentifier(), subCommand.getName()).toString());
        }
        return super.addArgument(argument, group);
    }

    @Override
    public final void setUsageArgument(BooleanArgument argument, OutputStream outputStream) {
        super.setUsageArgument(argument, outputStream);
        this.usageGroupArguments.put(argument, Collections.emptySet());
    }

    public final void setUsageGroupArgument(Argument argument, Collection<SubCommand> subCommands) {
        this.usageGroupArguments.put(argument, subCommands);
    }

    public final void defaultSubCommand(SubCommand subCommand) {
        String subCommandName = subCommand.getName();
        Reject.ifFalse(this.subCommands.containsKey(subCommandName.toLowerCase()), "Unknown subcommand " + subCommandName);
        this.defaultSubCommand = subCommand;
    }

    @Override
    final List<String> initializeArgumentParsing(String[] rawArguments) {
        this.selectedSubCommand = null;
        this.getTrailingArguments().clear();
        this.setUsageOrVersionDisplayed(false);
        return this.addDefaultSubCommandIfNeeded(rawArguments);
    }

    @Override
    TrailingArgumentsConstraints getTrailingArgumentsConstraints() {
        return this.selectedSubCommand != null ? this.selectedSubCommand.getTrailingArgumentsConstraints() : new TrailingArgumentsConstraints();
    }

    @Override
    void parseTrailingArgument(String arg) throws ArgumentException {
        if (this.parsingTrailingArguments || this.selectedSubCommand != null) {
            if (this.selectedSubCommand == null) {
                throw new ArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_INVALID.get());
            }
            super.parseTrailingArgument(arg);
        } else {
            SubCommand sc = (SubCommand)this.subCommands.get(arg);
            if (sc == null) {
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_INVALID_ARGUMENT.get(arg));
            }
            this.selectedSubCommand = sc;
        }
    }

    @Override
    final void normalizeArguments(Properties properties) throws ArgumentException {
        super.normalizeArguments(properties);
        if (this.selectedSubCommand != null) {
            SubCommandArgumentParser.fillArgumentsWithPropertiesIfNeeded(properties, this.selectedSubCommand.getArguments());
        }
    }

    @Override
    final Argument retrieveArgumentWithLongId(String argLongId) {
        Argument argument = super.retrieveArgumentWithLongId(argLongId);
        return argument == null && this.selectedSubCommand != null ? this.selectedSubCommand.getArgument(argLongId) : argument;
    }

    @Override
    final Argument retrieveArgumentWithShortId(char argShortId) {
        Argument argument = this.getArgumentForShortId(Character.valueOf(argShortId));
        return argument == null && this.selectedSubCommand != null ? this.selectedSubCommand.getArgument(Character.valueOf(argShortId)) : argument;
    }

    @Override
    final void processQuestionMarkArg() {
        super.processQuestionMarkArg();
        if (this.selectedSubCommand != null && this.getUsageArgument() != null) {
            this.getUsageArgument().setPresent(true);
        }
    }

    @Override
    final void processShortProductVersionArg() throws ArgumentException {
        if (this.dashVUsedBySubCommand()) {
            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get(Character.valueOf('V')));
        }
        this.printVersion();
    }

    private boolean dashVUsedBySubCommand() {
        for (SubCommand subCmd : this.subCommands.values()) {
            if (subCmd.getArgument(Character.valueOf('V')) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    final void printUsageIfArgMatch(Argument a) {
        if (this.usageGroupArguments.containsKey(a)) {
            this.getUsage(a);
        }
    }

    private List<String> addDefaultSubCommandIfNeeded(String[] rawArgumentsArray) {
        List<String> rawArguments = Arrays.asList(rawArgumentsArray);
        if (this.defaultSubCommand == null) {
            return rawArguments;
        }
        for (String argument : rawArgumentsArray) {
            if (!this.subCommands.containsKey(argument)) continue;
            return rawArguments;
        }
        ArrayList<String> argsWithDefaultSubCommand = new ArrayList<String>();
        argsWithDefaultSubCommand.add(this.defaultSubCommand.getName());
        argsWithDefaultSubCommand.addAll(Arrays.asList(rawArgumentsArray));
        this.automaticallySelectedDefaultSubCommand = true;
        return argsWithDefaultSubCommand;
    }

    private void getSubCommandUsage(StringBuilder buffer, SubCommand subCommand) {
        buffer.append(this.getLocalizableScriptName());
        buffer.append(" ");
        buffer.append(subCommand.getName());
        buffer.append(" ").append(CliMessages.INFO_SUBCMDPARSER_OPTIONS.get());
        subCommand.getTrailingArgumentsConstraints().append(buffer);
        buffer.append(StaticUtils.EOL);
        this.wrap(buffer, subCommand.getDescription());
        buffer.append(StaticUtils.EOL);
        if (!this.getArguments().isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append(CliMessages.INFO_GLOBAL_OPTIONS.get());
            buffer.append(StaticUtils.EOL);
            buffer.append(INDENT);
            buffer.append(CliMessages.INFO_GLOBAL_OPTIONS_REFERENCE.get(this.getScriptNameOrJava()));
            buffer.append(StaticUtils.EOL);
        }
        if (!subCommand.getArguments().isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append(CliMessages.INFO_SUBCMD_OPTIONS.get());
            buffer.append(StaticUtils.EOL);
        }
        for (Argument a : subCommand.getArguments()) {
            if (a.isHidden()) continue;
            this.printLineForShortLongArgument(a, buffer);
            this.indentAndWrap(buffer, INDENT, a.getDescription());
            if (!a.needsValue() || a.getDefaultValue() == null || a.getDefaultValue().length() <= 0) continue;
            this.indentAndWrap(buffer, INDENT, CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get(a.getDefaultValue()));
        }
    }

    @Override
    public final String getUsage() {
        this.unselectAutomaticallySelectedDefaultSubCommand();
        this.setUsageOrVersionDisplayed(true);
        StringBuilder buffer = new StringBuilder();
        if (this.selectedSubCommand == null) {
            if (System.getProperty("org.forgerock.opendj.gendoc") != null) {
                this.generateReferenceDoc(buffer, this.subCommands.values());
            } else if (this.usageGroupArguments.size() > 1) {
                this.getFullUsage(Collections.emptySet(), true, buffer);
            } else {
                this.getFullUsage(this.subCommands.values(), true, buffer);
            }
        } else {
            this.getSubCommandUsage(buffer, this.selectedSubCommand);
        }
        return buffer.toString();
    }

    final void addSubCommand(SubCommand subCommand) {
        String subCommandName = subCommand.getName();
        if (this.getSubCommand(subCommandName) != null) {
            throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_SUBCOMMAND.get(subCommandName).toString());
        }
        this.subCommands.put(subCommandName, subCommand);
    }

    public final SortedMap<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    private void getUsage(Argument a) {
        this.unselectAutomaticallySelectedDefaultSubCommand();
        this.setUsageOrVersionDisplayed(true);
        StringBuilder buffer = new StringBuilder();
        boolean isUsageArgument = this.isUsageArgument(a);
        if (isUsageArgument && this.selectedSubCommand != null) {
            this.getSubCommandUsage(buffer, this.selectedSubCommand);
        } else if (isUsageArgument && this.usageGroupArguments.size() <= 1) {
            this.getFullUsage(this.subCommands.values(), true, buffer);
        } else if (isUsageArgument) {
            this.getFullUsage(Collections.emptySet(), true, buffer);
        } else {
            this.getFullUsage(this.usageGroupArguments.get(a), false, buffer);
        }
        this.writeToUsageOutputStream(buffer);
    }

    private void unselectAutomaticallySelectedDefaultSubCommand() {
        if (this.automaticallySelectedDefaultSubCommand) {
            this.selectedSubCommand = null;
        }
    }

    private void getFullUsage(Collection<SubCommand> c, boolean showGlobalOptions, StringBuilder buffer) {
        LocalizableMessage toolDescription = this.getToolDescription();
        if (toolDescription != null && toolDescription.length() > 0) {
            buffer.append(Utils.wrapText(toolDescription, Utils.MAX_LINE_WIDTH - 1));
            buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
        }
        buffer.append(CliMessages.INFO_ARGPARSER_USAGE.get());
        buffer.append("  ");
        buffer.append(this.getScriptNameOrJava());
        if (this.subCommands.isEmpty()) {
            buffer.append(" ").append(CliMessages.INFO_SUBCMDPARSER_OPTIONS.get());
        } else {
            buffer.append(" ").append(CliMessages.INFO_SUBCMDPARSER_SUBCMD_AND_OPTIONS.get());
        }
        if (!this.subCommands.isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append(StaticUtils.EOL);
            if (c.isEmpty()) {
                buffer.append(CliMessages.INFO_SUBCMDPARSER_SUBCMD_HELP_HEADING.get());
            } else {
                buffer.append(CliMessages.INFO_SUBCMDPARSER_SUBCMD_HEADING.get());
            }
            buffer.append(StaticUtils.EOL);
        }
        if (c.isEmpty()) {
            for (Argument a : this.getArguments()) {
                if (a.isHidden() || !this.usageGroupArguments.containsKey(a) || this.isUsageArgument(a)) continue;
                this.printArgumentUsage(a, buffer);
            }
        } else {
            boolean isFirst = true;
            for (SubCommand sc : c) {
                if (sc.isHidden()) continue;
                if (isFirst) {
                    buffer.append(StaticUtils.EOL);
                }
                buffer.append(sc.getName());
                buffer.append(StaticUtils.EOL);
                this.indentAndWrap(buffer, INDENT, sc.getDescription());
                buffer.append(StaticUtils.EOL);
                isFirst = false;
            }
        }
        buffer.append(StaticUtils.EOL);
        if (showGlobalOptions) {
            if (this.subCommands.isEmpty()) {
                buffer.append(CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
            } else {
                buffer.append(CliMessages.INFO_SUBCMDPARSER_GLOBAL_HEADING.get());
            }
            buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
            boolean printGroupHeaders = this.printUsageGroupHeaders();
            for (ArgumentGroup argGroup : this.argumentGroupsForUsage) {
                LocalizableMessage groupDesc;
                if (argGroup.containsArguments() && printGroupHeaders && (groupDesc = argGroup.getDescription()) != null && !LocalizableMessage.EMPTY.equals(groupDesc)) {
                    buffer.append(StaticUtils.EOL);
                    buffer.append(Utils.wrapText(groupDesc.toString(), Utils.MAX_LINE_WIDTH - 1));
                    buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
                }
                for (Argument a : argGroup.getArguments()) {
                    if (a.isHidden() || this.usageGroupArguments.containsKey(a)) continue;
                    this.printArgumentUsage(a, buffer);
                }
            }
            Argument usageArgument = this.getUsageArgument();
            if (usageArgument != null) {
                this.printArgumentUsage(usageArgument, buffer);
            } else {
                buffer.append("-?");
            }
            buffer.append(StaticUtils.EOL);
        }
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        String value = this.getValueForUsage(a);
        Argument usageArgument = this.getUsageArgument();
        Character shortIDChar = a.getShortIdentifier();
        if (shortIDChar != null) {
            if (a.equals(usageArgument)) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortIDChar);
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                buffer.append(", --");
                buffer.append(longIDString);
            }
            buffer.append(value);
        } else {
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                if (a.equals(usageArgument)) {
                    buffer.append("-?, ");
                }
                buffer.append("--");
                buffer.append(longIDString);
                buffer.append(value);
            }
        }
        buffer.append(StaticUtils.EOL);
        this.indentAndWrap(buffer, INDENT, a.getDescription());
        if (a.needsValue() && a.getDefaultValue() != null && a.getDefaultValue().length() > 0) {
            this.indentAndWrap(buffer, INDENT, CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get(a.getDefaultValue()));
        }
    }

    private String getValueForUsage(Argument a) {
        if (a.needsValue()) {
            LocalizableMessage pHolder = a.getValuePlaceholder();
            if (pHolder != null) {
                return " " + pHolder;
            }
            return " {value}";
        }
        return "";
    }

    private void wrap(StringBuilder buffer, LocalizableMessage text) {
        this.indentAndWrap(buffer, "", text);
    }

    private void indentAndWrap(StringBuilder buffer, String indent, LocalizableMessage text) {
        int actualSize = Utils.MAX_LINE_WIDTH - indent.length() - COLUMN_ADJUST;
        SubCommandArgumentParser.indentAndWrap(indent, buffer, actualSize, text);
    }

    static void indentAndWrap(String indent, StringBuilder buffer, int actualSize, LocalizableMessage text) {
        if (text.length() <= actualSize) {
            buffer.append(indent);
            buffer.append(text);
            buffer.append(StaticUtils.EOL);
        } else {
            String s = text.toString();
            while (s.length() > actualSize) {
                int spacePos = s.lastIndexOf(32, actualSize);
                if (spacePos == -1) {
                    spacePos = s.indexOf(32);
                }
                if (spacePos == -1) {
                    buffer.append(indent).append(s).append(StaticUtils.EOL);
                    return;
                }
                buffer.append(indent);
                buffer.append(s.substring(0, spacePos).trim());
                s = s.substring(spacePos + 1).trim();
                buffer.append(StaticUtils.EOL);
            }
            if (s.length() > 0) {
                buffer.append(indent).append(s).append(StaticUtils.EOL);
            }
        }
    }

    private void generateReferenceDoc(StringBuilder builder, Collection<SubCommand> subCommands) {
        this.toRefEntry(builder, subCommands);
    }

    @Override
    final String getSynopsisArgs() {
        if (this.subCommands.isEmpty()) {
            return CliMessages.INFO_SUBCMDPARSER_OPTIONS.get().toString();
        }
        return CliMessages.INFO_SUBCMDPARSER_SUBCMD_AND_OPTIONS.get().toString();
    }

    private void toRefEntry(StringBuilder builder, Collection<SubCommand> subCommands) {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            throw new IllegalStateException("The script name should have been set via the environment property 'com.forgerock.opendj.ldap.tools.scriptName'.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locale", Locale.getDefault().getLanguage());
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("name", scriptName);
        map.put("shortDesc", this.getShortToolDescription());
        map.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
        map.put("args", this.getSynopsisArgs());
        map.put("description", this.eolToNewPara(this.getToolDescription()));
        map.put("info", this.getDocToolDescriptionSupplement());
        if (!this.getArguments().isEmpty()) {
            map.put("optionSection", this.getOptionsRefSect1(scriptName));
        }
        map.put("subcommands", this.toRefSect1(scriptName, subCommands));
        map.put("trailingSectionString", System.getProperty("org.forgerock.opendj.gendoc.trailing"));
        DocGenerationHelper.applyTemplate(builder, "refEntry.ftl", map);
    }

    private String toRefSect1(String scriptName, Collection<SubCommand> subCommands) {
        if (subCommands.isEmpty()) {
            return "";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", scriptName);
        map.put("title", CliMessages.REF_TITLE_SUBCOMMANDS.get());
        map.put("info", this.getDocSubcommandsDescriptionSupplement());
        if (!scriptName.equals("dsconfig")) {
            map.put("intro", CliMessages.REF_INTRO_SUBCOMMANDS.get(scriptName));
        }
        ArrayList<String> scUsageList = new ArrayList<String>();
        for (SubCommand subCommand : subCommands) {
            if (subCommand.isHidden()) continue;
            if (scriptName.equals("dsconfig")) {
                scUsageList.add("");
                continue;
            }
            scUsageList.add(this.toRefSect2(scriptName, subCommand));
        }
        map.put("subcommands", scUsageList);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "refSect1.ftl", map);
        return sb.toString();
    }

    private String toRefSect2(String scriptName, SubCommand subCommand) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", scriptName + "-" + subCommand.getName());
        String name = scriptName + " " + subCommand.getName();
        map.put("name", name);
        map.put("description", this.eolToNewPara(subCommand.getDescription()));
        map.put("optionsTitle", CliMessages.REF_TITLE_OPTIONS.get());
        map.put("optionsIntro", CliMessages.REF_INTRO_OPTIONS.get(name));
        map.put("info", subCommand.getDocDescriptionSupplement());
        this.setSubCommandOptionsInfo(map, subCommand);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "refSect2.ftl", map);
        return sb.toString();
    }

    private void setSubCommandOptionsInfo(Map<String, Object> map, SubCommand subCommand) {
        if (!subCommand.getArguments().isEmpty()) {
            LinkedList options = new LinkedList();
            for (Argument a : subCommand.getArguments()) {
                if (a.isHidden()) continue;
                HashMap<String, LocalizableMessage> info = new HashMap<String, LocalizableMessage>();
                String defaultValue = this.isHostNameArgument(a) ? "localhost.localdomain" : a.getDefaultValue();
                info.put("default", defaultValue != null ? CliMessages.REF_DEFAULT.get(defaultValue) : null);
                info.put("doc", a.getDocDescriptionSupplement());
                HashMap<String, Object> option = new HashMap<String, Object>();
                option.put("synopsis", DocGenerationHelper.getOptionSynopsis(a));
                option.put("description", this.eolToNewPara(a.getDescription()));
                option.put("info", info);
                options.add(option);
            }
            map.put("options", options);
        }
    }
}

