<#--
 # The contents of this file are subject to the terms of the Common Development and
 # Distribution License (the License). You may not use this file except in compliance with the
 # License.
 #
 # You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 # specific language governing permission and limitations under the License.
 #
 # When distributing Covered Software, include this CDDL Header Notice in each file and include
 # the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 # Header, with the fields enclosed by brackets [] replaced by your own identifying
 # information: "Portions Copyright [year] [name of copyright owner]".
 #
 # Copyright 2017 ForgeRock AS.
 #-->
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="date" content="${now?datetime}">
    <link rel="stylesheet" href="style.css">
    <title>${title}</title>
  </head>

  <body>
    <div id="container">
    <h2 class="title">${title}</h2>

    <p>
    This reference describes server configuration settings
    that you can view and edit with the <code>dsconfig</code> command.
    The <code>dsconfig</code> command is
    the primary tool for managing the server configuration,
    which follows an object-oriented configuration model.
    Each configuration object has its own properties.
    Configuration objects can be related to each other
    by inheritance and by reference.
    </p>

    <p>
    The server configuration model exposes a wide range of configurable features.
    As a consequence, the <code>dsconfig</code> command has many subcommands.
    Subcommands exist to create, list, and delete configuration objects,
    and to get and set properties of configuration objects.
    Their names reflect these five actions:
    </p>

    <ul>
      <li><code>create-<i>object</i></code></li>
      <li><code>list-<i>objects</i></code></li>
      <li><code>delete-<i>object</i></code></li>
      <li><code>get-<i>object</i>-prop</code></li>
      <li><code>set-<i>object</i>-prop</code></li>
    </ul>

    <p>
    Each configuration <i>object</i> has a user-friendly name,
    such as <code>Connection Handler</code>.
    Subcommand names use lower-case, hyphenated versions of the friendly names,
    as in <code>create-connection-handler</code>.
    </p>

    <p>
    Tabs in the left menu show alternative views of the configuration model:
    </p>

    <ul>
      <li>The <b>Subcommands</b> view lists <code>dsconfig</code> subcommands
          with links to pages describing their use.</li>

      <li>The <b>Inheritance</b> view represents
          the inheritance relationships between configuration objects.
          A child object inherits all properties of its parent.</li>

      <li>The <b>Objects</b> view lists all configuration objects
          with links to each object.</li>

      <li>The <b>Properties</b> view lists all configuration properties
          with links to the objects having the property.</li>
    </ul>
    </div>
    <footer><p>Copyright 2011-${now?string["yyyy"]} ForgeRock AS.</p></footer>
  </body>
</html>
