/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.authz.Utils;

final class AuthzIdTemplate {
    private static final Impl DN_TEMPLATE_IMPL = new Impl(){

        @Override
        public String formatAsAuthzId(AuthzIdTemplate t, Object[] templateVariables) {
            return Dn.format(t.formatString, Schema.getCoreSchema(), templateVariables).toString();
        }
    };
    private static final Impl UID_TEMPLATE_IMPL = new Impl(){

        @Override
        public String formatAsAuthzId(AuthzIdTemplate t, Object[] templateVariables) {
            return String.format(Locale.ENGLISH, t.formatString, templateVariables);
        }
    };
    private static final Pattern TEMPLATE_KEY_RE = Pattern.compile("\\{([^}]+)\\}");
    private final TemplateType type;
    private final String formatString;
    private final List<String> keys = new ArrayList<String>();
    private final String template;

    AuthzIdTemplate(String template) {
        this.type = TemplateType.parseTemplateType(template);
        this.formatString = this.formatTemplate(template);
        this.template = template;
    }

    private String formatTemplate(String template) {
        Matcher matcher = TEMPLATE_KEY_RE.matcher(template);
        StringBuffer buffer = new StringBuffer(template.length());
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "%s");
            this.keys.add(matcher.group(1));
        }
        matcher.appendTail(buffer);
        return this.type.removeTemplateKey(buffer.toString());
    }

    public String toString() {
        return this.template;
    }

    String getSecurityContextId() {
        return this.type.getSecurityContextId();
    }

    String formatAsAuthzId(JsonValue principals) {
        Object[] templateVariables = this.getPrincipalsForFormatting(principals);
        return this.type.getImpl().formatAsAuthzId(this, templateVariables);
    }

    private String[] getPrincipalsForFormatting(JsonValue principals) {
        String[] values = new String[this.keys.size()];
        for (int i = 0; i < values.length; ++i) {
            String key = this.keys.get(i);
            JsonValue value = principals.get(new JsonPointer(key));
            if (value == null) {
                throw Utils.newIllegalArgumentException(Rest2ldapMessages.ERR_AUTHZID_DECODER_PRINCIPAL_CANNOT_BE_DETERMINED.get(key));
            }
            Object object = value.getObject();
            if (!this.isJsonPrimitive(object)) {
                throw Utils.newIllegalArgumentException(Rest2ldapMessages.ERR_AUTHZID_DECODER_PRINCIPAL_INVALID_DATA_TYPE.get(key));
            }
            values[i] = String.valueOf(object);
        }
        return values;
    }

    private boolean isJsonPrimitive(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number;
    }

    static /* synthetic */ Impl access$100() {
        return DN_TEMPLATE_IMPL;
    }

    static /* synthetic */ Impl access$200() {
        return UID_TEMPLATE_IMPL;
    }

    private static enum TemplateType {
        DN("dn:", "dn", AuthzIdTemplate.access$100()),
        UID("u:", "id", AuthzIdTemplate.access$200());

        private final String key;
        private final String securityContextId;
        private final Impl impl;

        private TemplateType(String key, String securityContextId, Impl impl) {
            this.key = key;
            this.securityContextId = securityContextId;
            this.impl = impl;
        }

        private String getSecurityContextId() {
            return this.securityContextId;
        }

        private Impl getImpl() {
            return this.impl;
        }

        private static TemplateType parseTemplateType(String template) {
            for (TemplateType type : TemplateType.values()) {
                if (!template.startsWith(type.key)) continue;
                return type;
            }
            throw Utils.newIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_INVALID_AUTHZID_TEMPLATE.get(template, org.forgerock.util.Utils.joinAsString(",", TemplateType.getSupportedStartKeys())));
        }

        private static List<String> getSupportedStartKeys() {
            ArrayList<String> startKeys = new ArrayList<String>();
            for (TemplateType type : TemplateType.values()) {
                startKeys.add(type.key);
            }
            return startKeys;
        }

        private String removeTemplateKey(String formattedString) {
            return formattedString.substring(this.key.length()).trim();
        }
    }

    private static interface Impl {
        public String formatAsAuthzId(AuthzIdTemplate var1, Object[] var2);
    }
}

