/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.rest2ldap.AbstractRequestHandler;
import org.forgerock.opendj.rest2ldap.NamingStrategy;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.RoutingContext;
import org.forgerock.opendj.rest2ldap.SubResource;
import org.forgerock.opendj.rest2ldap.SubResourceImpl;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class SubResourceSingleton
extends SubResource {
    private static final NamingStrategy SINGLETON_NAMING_STRATEGY = new NamingStrategy(){

        @Override
        public SearchRequest createSearchRequest(Dn baseDn, String resourceId) {
            return Requests.newSearchRequest(baseDn, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), new String[0]);
        }

        @Override
        public String getResourceIdLdapAttribute() {
            return null;
        }

        @Override
        public String decodeResourceId(Entry entry) {
            return null;
        }

        @Override
        public void encodeResourceId(Dn baseDn, String resourceId, Entry entry) throws ResourceException {
        }
    };

    SubResourceSingleton(String resourceId) {
        super(resourceId);
    }

    public SubResourceSingleton urlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    public SubResourceSingleton dnTemplate(String dnTemplate) {
        this.dnTemplateString = dnTemplate;
        return this;
    }

    public SubResourceSingleton isReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    @Override
    Router addRoutes(Router router) {
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, this.urlTemplate), this.readOnly(new InstanceHandler()));
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, this.urlTemplate), this.readOnly(new SubResource.SubResourceHandler()));
        return router;
    }

    @Override
    Promise<RoutingContext, ResourceException> route(Context context) {
        return Promises.newResultPromise(RoutingContext.newRoutingContext(context, this.dnFrom(context), this.resource));
    }

    private SubResourceImpl singleton(Context context) {
        return new SubResourceImpl(this.rest2Ldap, this.dnFrom(context), null, SINGLETON_NAMING_STRATEGY, this.resource);
    }

    private final class InstanceHandler
    extends AbstractRequestHandler {
        private InstanceHandler() {
        }

        @Override
        public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
            return SubResourceSingleton.this.singleton(context).action(context, null, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleCreate(Context context, final CreateRequest request) {
            return SubResourceSingleton.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResourceSingleton.this.subResourceRouterFrom(context).handleCreate(context, request);
                }
            }).thenCatch(this.convert404To400());
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
            return SubResourceSingleton.this.singleton(context).patch(context, null, request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> handleQuery(Context context, final QueryRequest request, final QueryResourceHandler handler) {
            return SubResourceSingleton.this.route(context).thenAsync(new AsyncFunction<RoutingContext, QueryResponse, ResourceException>(){

                @Override
                public Promise<QueryResponse, ResourceException> apply(RoutingContext context) {
                    return SubResourceSingleton.this.subResourceRouterFrom(context).handleQuery(context, request, handler);
                }
            }).thenCatch(this.convert404To400());
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
            return SubResourceSingleton.this.singleton(context).read(context, null, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
            return SubResourceSingleton.this.singleton(context).update(context, null, request);
        }

        @Override
        protected <V> Promise<V, ResourceException> handleRequest(Context context, Request request) {
            return new BadRequestException(Rest2ldapMessages.ERR_UNSUPPORTED_REQUEST_AGAINST_SINGLETON.get().toString()).asPromise();
        }

        private <T> Function<ResourceException, T, ResourceException> convert404To400() {
            return SubResource.convert404To400(Rest2ldapMessages.ERR_UNSUPPORTED_REQUEST_AGAINST_SINGLETON.get());
        }

        @Override
        public ApiDescription api(ApiProducer<ApiDescription> producer) {
            return SubResourceSingleton.this.getResource().instanceApi(SubResourceSingleton.this.isReadOnly);
        }
    }
}

