/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.util.Reject;

public class ConnectionEntryReader
implements EntryReader {
    private final BufferHandler buffer;
    private final LdapPromise<Result> promise;
    private Response nextResponse;

    public ConnectionEntryReader(Connection connection, SearchRequest searchRequest) {
        this(connection, searchRequest, new LinkedBlockingQueue<Response>());
    }

    public ConnectionEntryReader(Connection connection, SearchRequest searchRequest, BlockingQueue<Response> entries) {
        Reject.ifNull(connection);
        this.buffer = new BufferHandler(entries);
        this.promise = connection.searchAsync(searchRequest, this.buffer).thenOnResult(this.buffer).thenOnException(this.buffer);
    }

    @Override
    public void close() {
        this.promise.cancel(true);
    }

    @Override
    public boolean hasNext() throws LdapException {
        Response r = this.getNextResponse();
        if (!(r instanceof Result)) {
            return true;
        }
        Result result = (Result)r;
        if (result.isSuccess()) {
            return false;
        }
        throw LdapException.newLdapException(result);
    }

    public boolean isEntry() throws LdapException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Response r = this.nextResponse;
        if (r instanceof SearchResultEntry) {
            return true;
        }
        if (r instanceof SearchResultReference) {
            return false;
        }
        throw new RuntimeException("Unexpected response type: " + r.getClass());
    }

    public boolean isReference() throws LdapException {
        return !this.isEntry();
    }

    @Override
    public SearchResultEntry readEntry() throws SearchResultReferenceIOException, LdapException {
        if (this.isEntry()) {
            SearchResultEntry entry = (SearchResultEntry)this.nextResponse;
            this.nextResponse = null;
            return entry;
        }
        SearchResultReference reference = (SearchResultReference)this.nextResponse;
        this.nextResponse = null;
        throw new SearchResultReferenceIOException(reference);
    }

    public SearchResultReference readReference() throws LdapException {
        if (this.isReference()) {
            SearchResultReference reference = (SearchResultReference)this.nextResponse;
            this.nextResponse = null;
            return reference;
        }
        return null;
    }

    public Result readResult() throws LdapException {
        if (this.hasNext()) {
            throw new IllegalStateException();
        }
        return (Result)this.nextResponse;
    }

    private Response getNextResponse() throws LdapException {
        while (this.nextResponse == null) {
            try {
                this.nextResponse = (Response)this.buffer.responses.poll(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
            }
            if (this.nextResponse != null || !this.buffer.isInterrupted) continue;
            this.nextResponse = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR);
            break;
        }
        return this.nextResponse;
    }

    private static final class BufferHandler
    implements SearchResultHandler,
    LdapResultHandler<Result> {
        private final BlockingQueue<Response> responses;
        private volatile boolean isInterrupted;

        private BufferHandler(BlockingQueue<Response> responses) {
            this.responses = responses;
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            try {
                this.responses.put(entry);
                return true;
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public void handleException(LdapException error) {
            try {
                this.responses.put(error.getResult());
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            try {
                this.responses.put(reference);
                return true;
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public void handleResult(Result result) {
            try {
                this.responses.put(result);
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
        }
    }
}

