/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseWrapper;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;

public final class LdapPromises {
    private LdapPromises() {
    }

    public static <R> LdapPromise<R> asLdapPromise(Promise<R, LdapException> wrappedPromise) {
        return LdapPromises.wrap(wrappedPromise, -1);
    }

    public static ResultLdapPromiseImpl<BindRequest, BindResult> newBindLdapPromise(int requestId, BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        PromiseImpl innerPromise = LdapPromises.newInnerBindOrStartTlsPromise();
        return new ResultLdapPromiseImpl<BindRequest, BindResult>(innerPromise, requestId, request, intermediateResponseHandler){

            @Override
            protected BindResult newErrorResult(ResultCode resultCode, CharSequence diagnosticMessage, Throwable cause) {
                return Responses.newBindResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }

            @Override
            public boolean isBindOrStartTls() {
                return true;
            }
        };
    }

    public static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(int requestId, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl<CompareResult, LdapException> innerPromise = LdapPromises.newInnerPromise(connection, requestId);
        return LdapPromises.newCompareLdapPromise(innerPromise, requestId, request, intermediateResponseHandler);
    }

    public static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(int requestId, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapConnectionImpl connection) {
        PromiseImpl<CompareResult, LdapException> innerPromise = LdapPromises.newInnerPromise(connection, requestId);
        return LdapPromises.newCompareLdapPromise(innerPromise, requestId, request, intermediateResponseHandler);
    }

    private static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(PromiseImpl<CompareResult, LdapException> innerPromise, int requestId, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return new ResultLdapPromiseImpl<CompareRequest, CompareResult>(innerPromise, requestId, request, intermediateResponseHandler){

            @Override
            protected CompareResult newErrorResult(ResultCode resultCode, CharSequence diagnosticMessage, Throwable cause) {
                return Responses.newCompareResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static <S extends ExtendedResult> ExtendedResultLdapPromiseImpl<S> newExtendedLdapPromise(int requestId, ExtendedRequest<S> request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl<S, LdapException> innerPromise = !"1.3.6.1.4.1.1466.20037".equals(request.getOid()) ? LdapPromises.newInnerBindOrStartTlsPromise() : LdapPromises.newInnerPromise(connection, requestId);
        return new ExtendedResultLdapPromiseImpl<S>(innerPromise, requestId, request, intermediateResponseHandler);
    }

    public static <S extends ExtendedResult> ExtendedResultLdapPromiseImpl<S> newExtendedLdapPromise(int requestId, ExtendedRequest<S> request, IntermediateResponseHandler intermediateResponseHandler, LdapConnectionImpl connection) {
        PromiseImpl<S, LdapException> innerPromise = !"1.3.6.1.4.1.1466.20037".equals(request.getOid()) ? LdapPromises.newInnerBindOrStartTlsPromise() : LdapPromises.newInnerPromise(connection, requestId);
        return new ExtendedResultLdapPromiseImpl<S>(innerPromise, requestId, request, intermediateResponseHandler);
    }

    public static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(int requestId, R request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl<Result, LdapException> innerPromise = LdapPromises.newInnerPromise(connection, requestId);
        return LdapPromises.newResultLdapPromise(innerPromise, requestId, request, intermediateResponseHandler);
    }

    public static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(int requestId, R request, IntermediateResponseHandler intermediateResponseHandler, LdapConnectionImpl connection) {
        PromiseImpl<Result, LdapException> innerPromise = LdapPromises.newInnerPromise(connection, requestId);
        return LdapPromises.newResultLdapPromise(innerPromise, requestId, request, intermediateResponseHandler);
    }

    private static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(PromiseImpl<Result, LdapException> innerPromise, int requestID, R request, IntermediateResponseHandler intermediateResponseHandler) {
        return new ResultLdapPromiseImpl<R, Result>(innerPromise, requestID, request, intermediateResponseHandler){

            @Override
            protected Result newErrorResult(ResultCode resultCode, CharSequence diagnosticMessage, Throwable cause) {
                return Responses.newResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static SearchResultLdapPromiseImpl newSearchLdapPromise(int requestId, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new SearchResultLdapPromiseImpl(LdapPromises.newInnerPromise(connection, requestId), requestId, request, resultHandler, intermediateResponseHandler);
    }

    public static SearchResultLdapPromiseImpl newSearchLdapPromise(int requestId, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, LdapConnectionImpl connection) {
        return new SearchResultLdapPromiseImpl(LdapPromises.newInnerPromise(connection, requestId), requestId, request, resultHandler, intermediateResponseHandler);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), -1);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error, int requestId) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), requestId);
    }

    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result) {
        return LdapPromises.wrap(Promises.newResultPromise(result), -1);
    }

    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result, int requestId) {
        return LdapPromises.wrap(Promises.newResultPromise(result), requestId);
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerBindOrStartTlsPromise() {
        return new PromiseImpl<S, LdapException>(){

            @Override
            protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                return null;
            }
        };
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerPromise(final Connection connection, final int requestId) {
        return new PromiseImpl<S, LdapException>(){

            @Override
            protected final LdapException tryCancel(boolean mayInterruptIfRunning) {
                connection.abandonAsync(Requests.newAbandonRequest(requestId));
                return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED);
            }
        };
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerPromise(final LdapConnectionImpl connection, final int requestId) {
        return new PromiseImpl<S, LdapException>(){

            @Override
            protected final LdapException tryCancel(boolean mayInterruptIfRunning) {
                connection.abandonAsync(Requests.newAbandonRequest(requestId));
                return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED);
            }
        };
    }

    static <R> LdapPromise<R> wrap(Promise<R, LdapException> wrappedPromise, int requestId) {
        return new LdapPromiseWrapper(wrappedPromise, requestId);
    }
}

