/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.math.BigInteger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class IntegerOrderingMatchingRuleImpl
extends AbstractOrderingMatchingRuleImpl {
    static final byte SIGN_MASK_POSITIVE = 0;
    static final byte SIGN_MASK_NEGATIVE = -1;

    static ByteString normalizeValueAndEncode(ByteSequence value) throws DecodeException {
        BigInteger bi;
        try {
            bi = new BigInteger(value.toString());
        }
        catch (Exception e) {
            throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_INTEGER.get(value));
        }
        byte[] absBytes = bi.abs().toByteArray();
        int length = absBytes.length;
        boolean removeLeadingByte = length > 1 && absBytes[0] == 0;
        int trimmedLength = removeLeadingByte ? length - 1 : length;
        int startIndex = removeLeadingByte ? 1 : 0;
        byte signMask = bi.signum() < 0 ? (byte)-1 : 0;
        ByteStringBuilder builder = new ByteStringBuilder(trimmedLength + 5);
        IntegerOrderingMatchingRuleImpl.encodeHeader(builder, trimmedLength, signMask);
        for (int i = startIndex; i < length; ++i) {
            builder.appendByte(absBytes[i] ^ signMask);
        }
        return builder.toByteString();
    }

    static void encodeHeader(ByteStringBuilder builder, int length, byte signMask) {
        if ((length & 0xF) == length) {
            byte b0 = (byte)(0x80 | length & 0xF);
            builder.appendByte(b0 ^ signMask);
        } else if ((length & 0xFFF) == length) {
            byte b0 = (byte)(0x90 | length >> 8 & 0xF);
            builder.appendByte(b0 ^ signMask);
            builder.appendByte(length & 0xFF ^ signMask);
        } else if ((length & 0xFFFFF) == length) {
            byte b0 = (byte)(0xA0 | length >> 16 & 0xF);
            builder.appendByte(b0 ^ signMask);
            builder.appendByte(length >> 8 & 0xFF ^ signMask);
            builder.appendByte(length & 0xFF ^ signMask);
        } else if ((length & 0xFFFFFFF) == length) {
            byte b0 = (byte)(0xB0 | length >> 24 & 0xF);
            builder.appendByte(b0 ^ signMask);
            builder.appendByte(length >> 16 & 0xFF ^ signMask);
            builder.appendByte(length >> 8 & 0xFF ^ signMask);
            builder.appendByte(length & 0xFF ^ signMask);
        } else {
            byte b0 = (byte)(0xC0 | length >> 28 & 0xF);
            builder.appendByte(b0 ^ signMask);
            builder.appendByte(length >> 20 & 0xFF ^ signMask);
            builder.appendByte(length >> 12 & 0xFF ^ signMask);
            builder.appendByte(length >> 4 & 0xFF ^ signMask);
            builder.appendByte(length << 4 & 0xFF ^ signMask);
        }
    }

    public IntegerOrderingMatchingRuleImpl() {
        super("integerMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        return IntegerOrderingMatchingRuleImpl.normalizeValueAndEncode(value);
    }
}

