/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.util.Reject;

final class CompareRequestImpl
extends AbstractProtocolOpImpl<CompareRequest>
implements CompareRequest {
    private ByteString assertionValue;
    private AttributeDescription attributeDescription;
    private Dn name;

    CompareRequestImpl(CompareRequest compareRequest) {
        super(compareRequest);
        this.name = compareRequest.getName();
        this.attributeDescription = compareRequest.getAttributeDescription();
        this.assertionValue = compareRequest.getAssertionValue();
    }

    CompareRequestImpl(Dn name, AttributeDescription attributeDescription, ByteString assertionValue) {
        this.name = name;
        this.attributeDescription = attributeDescription;
        this.assertionValue = assertionValue;
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public String getAssertionValueAsString() {
        return this.assertionValue.toString();
    }

    @Override
    public AttributeDescription getAttributeDescription() {
        return this.attributeDescription;
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public CompareRequest setAssertionValue(Object value) {
        Reject.ifNull(value);
        this.assertionValue = ByteString.valueOfObject(value);
        return this;
    }

    @Override
    public CompareRequest setAttributeDescription(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.attributeDescription = attributeDescription;
        return this;
    }

    @Override
    public CompareRequest setAttributeDescription(String attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.attributeDescription = AttributeDescription.valueOf(attributeDescription);
        return this;
    }

    @Override
    public CompareRequest setName(Dn dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public CompareRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = Dn.valueOf(dn);
        return this;
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.COMPARE;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompareRequest(name=");
        builder.append(this.getName());
        builder.append(", attributeDescription=");
        builder.append(this.getAttributeDescription());
        builder.append(", assertionValue=");
        builder.append(this.getAssertionValueAsString());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    CompareRequest getThis() {
        return this;
    }
}

