/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConsistentHashMap;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.IntermediateResponse;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;

final class ConsistentHashDistributionLoadBalancer
implements ConnectionFactory {
    private static final String NAME = ConsistentHashDistributionLoadBalancer.class.getSimpleName();
    private final ConsistentHashMap<? extends ConnectionFactory> partitions;
    private final Dn partitionBaseDn;

    ConsistentHashDistributionLoadBalancer(Dn partitionBaseDn, ConsistentHashMap<? extends ConnectionFactory> partitions) {
        this.partitionBaseDn = partitionBaseDn;
        this.partitions = partitions;
    }

    @Override
    public final void close() {
        Utils.closeSilently(this.partitions.getAll());
    }

    public final String toString() {
        return NAME + '(' + Utils.joinAsString(",", this.partitions) + ')';
    }

    @Override
    public final Connection getConnection() throws LdapException {
        return new ConnectionImpl();
    }

    @Override
    public final Promise<Connection, LdapException> getConnectionAsync() {
        return Promises.newResultPromise(new ConnectionImpl());
    }

    private class ConnectionImpl
    extends AbstractAsynchronousConnection {
        private final ConnectionState state = new ConnectionState();

        private ConnectionImpl() {
        }

        @Override
        public String toString() {
            return NAME + "Connection";
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }

        @Override
        public LdapPromise<Result> addAsync(final AddRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            ConnectionFactory partition = this.getPartition(request.getName());
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.addAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            Dn dn = Requests.dnOfRequest(request);
            if (dn == null) {
                return LdapPromises.newFailedLdapPromise(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.DISTRIBUTION_UNRESOLVABLE_PARTITION_ID_FOR_BIND.get()));
            }
            ConnectionFactory partition = this.getPartition(dn);
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, BindResult, LdapException>(){

                @Override
                public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.bindAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.state.notifyConnectionClosed();
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(final CompareRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            ConnectionFactory partition = this.getPartition(request.getName());
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, CompareResult, LdapException>(){

                @Override
                public Promise<CompareResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.compareAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> deleteAsync(final DeleteRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            ConnectionFactory partition = this.getPartition(request.getName());
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.deleteAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            Dn dn = Requests.dnOfRequest(request);
            if (dn == null) {
                return LdapPromises.newFailedLdapPromise(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.DISTRIBUTION_UNRESOLVABLE_PARTITION_ID_FOR_EXT_OP.get()));
            }
            ConnectionFactory partition = this.getPartition(dn);
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, R, LdapException>(){

                @Override
                public Promise<R, LdapException> apply(Connection connection) throws LdapException {
                    return connection.extendedRequestAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(final ModifyRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            ConnectionFactory partition = this.getPartition(request.getName());
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> modifyDnAsync(final ModifyDnRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            Dn newParent;
            Dn newDN;
            ConnectionFactory newPartition;
            Dn oldDN = request.getName();
            ConnectionFactory oldPartition = this.getPartition(oldDN);
            if (oldPartition != (newPartition = this.getPartition(newDN = (newParent = request.getNewSuperior() != null ? request.getNewSuperior() : oldDN.parent()).child(request.getNewRdn())))) {
                return this.unwillingToPerform(CoreMessages.DISTRIBUTION_MODDN_SPANS_MULTIPLE_PARTITIONS.get());
            }
            return this.connectAndSendRequest(oldPartition, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyDnAsync(request, intermediateResponseHandler);
                }
            });
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
            Dn dn = request.getName();
            switch (request.getScope().asEnum()) {
                case BASE_OBJECT: {
                    return this.searchSinglePartition(request, intermediateResponseHandler, entryHandler);
                }
                case SINGLE_LEVEL: {
                    if (dn.equals(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn)) {
                        return this.searchAllPartitions(request, intermediateResponseHandler, entryHandler);
                    }
                    return this.searchSinglePartition(request, intermediateResponseHandler, entryHandler);
                }
                case WHOLE_SUBTREE: {
                    if (dn.isSuperiorOrEqualTo(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn)) {
                        return this.splitAndSearchAllPartitions(request, intermediateResponseHandler, entryHandler);
                    }
                    return this.searchSinglePartition(request, intermediateResponseHandler, entryHandler);
                }
                case SUBORDINATES: {
                    if (dn.equals(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn)) {
                        return this.searchAllPartitions(request, intermediateResponseHandler, entryHandler);
                    }
                    if (dn.isSuperiorOrEqualTo(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn)) {
                        return this.splitAndSearchAllPartitions(request, intermediateResponseHandler, entryHandler);
                    }
                    return this.searchSinglePartition(request, intermediateResponseHandler, entryHandler);
                }
            }
            return this.unwillingToPerform(CoreMessages.DISTRIBUTION_UNSUPPORTED_SEARCH_SCOPE.get(request.getScope().intValue()));
        }

        private LdapPromise<Result> searchAllPartitions(SearchRequest request, IntermediateResponseHandler irh, SearchResultHandler srh) {
            return this.broadcastSearch(request, request, irh, srh);
        }

        private LdapPromise<Result> splitAndSearchAllPartitions(SearchRequest primarySearch, IntermediateResponseHandler irh, SearchResultHandler srh) {
            SearchRequest secondarySearch = Requests.copyOfSearchRequest(primarySearch).setName(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn).setScope(SearchScope.SUBORDINATES);
            return this.broadcastSearch(primarySearch, secondarySearch, irh, srh);
        }

        private LdapPromise<Result> broadcastSearch(SearchRequest primarySearch, SearchRequest secondarySearch, IntermediateResponseHandler irh, SearchResultHandler srh) {
            if (primarySearch.containsControl("2.16.840.1.113730.3.4.9")) {
                return this.unwillingToPerform(CoreMessages.DISTRIBUTION_VLV_CONTROL_NOT_SUPPORTED.get());
            }
            if (primarySearch.containsControl("1.2.840.113556.1.4.319")) {
                return this.unwillingToPerform(CoreMessages.DISTRIBUTION_SPR_CONTROL_NOT_SUPPORTED.get());
            }
            if (primarySearch.containsControl("1.2.840.113556.1.4.473")) {
                return this.unwillingToPerform(CoreMessages.DISTRIBUTION_SSS_CONTROL_NOT_SUPPORTED.get());
            }
            if (primarySearch.containsControl("2.16.840.1.113730.3.4.3")) {
                try {
                    PersistentSearchRequestControl control = primarySearch.getControl(PersistentSearchRequestControl.DECODER, new DecodeOptions());
                    if (!control.isChangesOnly()) {
                        return this.unwillingToPerform(CoreMessages.DISTRIBUTION_PSEARCH_CONTROL_NOT_SUPPORTED.get());
                    }
                }
                catch (DecodeException e) {
                    return LdapPromises.newFailedLdapPromise(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e.getMessage(), e));
                }
            }
            final ArrayList promises = new ArrayList(ConsistentHashDistributionLoadBalancer.this.partitions.size());
            ConnectionFactory primaryPartition = this.getPartition(primarySearch.getName());
            IntermediateResponseHandler sirh = this.synchronize(irh);
            SearchResultHandler ssrh = this.synchronize(srh);
            for (ConnectionFactory partition : ConsistentHashDistributionLoadBalancer.this.partitions.getAll()) {
                SearchRequest searchRequest = partition == primaryPartition ? primarySearch : secondarySearch;
                promises.add(this.searchSinglePartition(searchRequest, sirh, ssrh, partition));
            }
            final PromiseImpl<Result, LdapException> reducedPromise = new PromiseImpl<Result, LdapException>(){

                @Override
                protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                    for (Promise promise : promises) {
                        promise.cancel(mayInterruptIfRunning);
                    }
                    return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED);
                }
            };
            Promises.when(promises).thenOnResult(new ResultHandler<List<Result>>(){

                @Override
                public void handleResult(List<Result> results) {
                    reducedPromise.handleResult(results.get(0));
                }
            }).thenOnException(new ExceptionHandler<LdapException>(){

                @Override
                public void handleException(LdapException exception) {
                    reducedPromise.handleException(exception);
                }
            }).thenOnRuntimeException(new RuntimeExceptionHandler(){

                @Override
                public void handleRuntimeException(RuntimeException exception) {
                    reducedPromise.handleRuntimeException(exception);
                }
            }).thenFinally(new Runnable(){

                @Override
                public void run() {
                    for (Promise promise : promises) {
                        promise.cancel(true);
                    }
                }
            });
            return LdapPromises.asLdapPromise(reducedPromise);
        }

        private LdapPromise<Result> unwillingToPerform(LocalizableMessage msg) {
            return LdapPromises.newFailedLdapPromise(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, msg));
        }

        private LdapPromise<Result> searchSinglePartition(SearchRequest request, IntermediateResponseHandler irh, SearchResultHandler srh) {
            ConnectionFactory partition = this.getPartition(request.getName());
            return this.searchSinglePartition(request, irh, srh, partition);
        }

        private LdapPromise<Result> searchSinglePartition(final SearchRequest request, final IntermediateResponseHandler irh, final SearchResultHandler srh, ConnectionFactory partition) {
            return this.connectAndSendRequest(partition, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.searchAsync(request, irh, srh);
                }
            });
        }

        private SearchResultHandler synchronize(final SearchResultHandler srh) {
            return new SearchResultHandler(){

                @Override
                public synchronized boolean handleEntry(SearchResultEntry entry) {
                    return srh.handleEntry(entry);
                }

                @Override
                public synchronized boolean handleReference(SearchResultReference reference) {
                    return srh.handleReference(reference);
                }
            };
        }

        private IntermediateResponseHandler synchronize(final IntermediateResponseHandler irh) {
            return new IntermediateResponseHandler(){

                @Override
                public synchronized boolean handleIntermediateResponse(IntermediateResponse response) {
                    return irh.handleIntermediateResponse(response);
                }
            };
        }

        private ConnectionFactory getPartition(Dn dn) {
            Dn partitionDN = this.getPartitionDN(dn);
            return (ConnectionFactory)ConsistentHashDistributionLoadBalancer.this.partitions.get((partitionDN != null ? partitionDN : dn).toNormalizedUrlSafeString());
        }

        private Dn getPartitionDN(Dn dn) {
            int depthBelowBaseDN = dn.size() - ConsistentHashDistributionLoadBalancer.this.partitionBaseDn.size();
            if (depthBelowBaseDN > 0 && dn.isSubordinateOrEqualTo(ConsistentHashDistributionLoadBalancer.this.partitionBaseDn)) {
                return dn.parent(depthBelowBaseDN - 1);
            }
            return null;
        }

        private <R> LdapPromise<R> connectAndSendRequest(ConnectionFactory partition, AsyncFunction<Connection, R, LdapException> doRequest) {
            if (this.state.isClosed()) {
                throw new IllegalStateException("Connection is already closed");
            }
            final AtomicReference connectionHolder = new AtomicReference();
            return this.connectAsync(partition).thenOnResult(new ResultHandler<Connection>(){

                @Override
                public void handleResult(Connection connection) {
                    connectionHolder.set(connection);
                }
            }).thenAsync(doRequest).thenFinally(new Runnable(){

                @Override
                public void run() {
                    Utils.closeSilently((Closeable)connectionHolder.get());
                }
            });
        }

        private LdapPromise<Connection> connectAsync(ConnectionFactory partition) {
            return LdapPromises.asLdapPromise(partition.getConnectionAsync().thenOnException(new ExceptionHandler<LdapException>(){

                @Override
                public void handleException(LdapException e) {
                    ConnectionImpl.this.state.notifyConnectionError(false, e);
                }
            }));
        }
    }
}

