/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.AbstractConnection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.spi.LdapPromises;

public abstract class AbstractSynchronousConnection
extends AbstractConnection {
    protected AbstractSynchronousConnection() {
    }

    @Override
    public LdapPromise<Void> abandonAsync(AbandonRequest request) {
        throw new UnsupportedOperationException("Abandon requests are not supported for synchronous connections");
    }

    @Override
    public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.add(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.bind(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.compare(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.delete(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.extendedRequest(request, intermediateResponseHandler));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.modify(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        try {
            return this.thenOnResult(this.modifyDn(request));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        try {
            return this.thenOnResult(this.search(request, entryHandler));
        }
        catch (LdapException e) {
            return this.onException(e);
        }
    }

    private <R extends Result> LdapPromise<R> onException(LdapException e) {
        return LdapPromises.newFailedLdapPromise(e);
    }

    private <R extends Result> LdapPromise<R> thenOnResult(R result) {
        return LdapPromises.newSuccessfulLdapPromise(result);
    }
}

