/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.AbstractAsn1Reader;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.glassfish.grizzly.Buffer;

final class Asn1BufferReader
extends AbstractAsn1Reader {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    private final CharBuffer stringBuffer = CharBuffer.allocate(512);
    private final LinkedList<BufferPosition> readerStack = new LinkedList();
    private int state = 0;
    private byte peekType;
    private int peekLength = -1;
    private final int maxElementSize;
    private Buffer reader;

    Asn1BufferReader(int maxElementSize) {
        this.maxElementSize = maxElementSize;
    }

    Asn1BufferReader setBuffer(Buffer buffer) {
        this.state = 0;
        this.peekType = 0;
        this.peekLength = -1;
        this.readerStack.clear();
        this.reader = buffer;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.reader.tryDispose();
        this.reader = null;
    }

    @Override
    public boolean elementAvailable() throws IOException {
        return !(this.state == 0 && !this.needTypeState(false) || this.state == 1 && !this.needFirstLengthByteState(false) || this.peekLength > this.reader.remaining());
    }

    @Override
    public boolean hasNextElement() throws IOException {
        return this.state != 0 || this.needTypeState(false);
    }

    @Override
    public int peekLength() throws IOException {
        this.peekType();
        if (this.state == 1) {
            this.needFirstLengthByteState(true);
        }
        return this.peekLength;
    }

    @Override
    public byte peekType() throws IOException {
        if (this.state == 0) {
            if (!this.reader.hasRemaining()) {
                throw DecodeException.fatalError(CoreMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get());
            }
            byte type = this.reader.get();
            this.peekType = type;
            this.state = 1;
        }
        return this.peekType;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean value;
        this.peekLength();
        if (this.peekLength != 1) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get(this.peekLength));
        }
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_BOOLEAN_TRUNCATED_VALUE.get(this.peekLength));
        }
        byte readByte = this.reader.get();
        this.state = 0;
        boolean bl = value = readByte != 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", (Object)this.peekType, (Object)this.peekLength, (Object)value);
        }
        return value;
    }

    @Override
    public void readEndSequence() throws IOException {
        BufferPosition bufferPosition = this.readerStack.poll();
        if (bufferPosition == null) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }
        if (this.reader.hasRemaining()) {
            logger.debug(LocalizableMessage.raw("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", this.reader.remaining()));
            this.reader.position(this.reader.position() + this.reader.remaining());
        }
        bufferPosition.apply(this.reader);
        this.state = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 END SEQUENCE");
        }
    }

    @Override
    public void readEndExplicitTag() throws IOException {
        this.readEndSequence();
    }

    @Override
    public void readEndSet() throws IOException {
        this.readEndSequence();
    }

    @Override
    public int readEnumerated() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength));
        }
        return (int)this.readInteger();
    }

    @Override
    public long readInteger() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength));
        }
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get(this.peekLength));
        }
        if (this.peekLength > 4) {
            long longValue = 0L;
            for (int i = 0; i < this.peekLength; ++i) {
                byte readByte = this.reader.get();
                if (i == 0 && readByte < 0) {
                    longValue = -1L;
                }
                longValue = longValue << 8 | (long)(readByte & 0xFF);
            }
            this.state = 0;
            if (logger.isTraceEnabled()) {
                logger.trace("READ ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)this.peekType, (Object)this.peekLength, (Object)longValue);
            }
            return longValue;
        }
        int intValue = 0;
        for (int i = 0; i < this.peekLength; ++i) {
            byte readByte = this.reader.get();
            if (i == 0 && readByte < 0) {
                intValue = -1;
            }
            intValue = intValue << 8 | readByte & 0xFF;
        }
        this.state = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)this.peekType, (Object)this.peekLength, (Object)intValue);
        }
        return intValue;
    }

    @Override
    public void readNull() throws IOException {
        this.peekLength();
        if (this.peekLength != 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_NULL_INVALID_LENGTH.get(this.peekLength));
        }
        this.state = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 NULL(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        }
    }

    @Override
    public ByteString readOctetString() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength));
        }
        this.state = 0;
        byte[] data = new byte[this.peekLength];
        this.reader.get(data);
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        }
        return ByteString.wrap(data);
    }

    @Override
    public ByteStringBuilder readOctetString(ByteStringBuilder builder) throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength));
        }
        int pos = this.reader.position();
        builder.appendBytes(this.reader.toByteBuffer(), this.peekLength);
        this.reader.position(pos + this.peekLength);
        this.state = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        }
        return builder;
    }

    @Override
    public String readOctetStringAsString() throws IOException {
        CoderResult result;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return "";
        }
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength));
        }
        this.state = 0;
        CharBuffer out = this.peekLength > this.stringBuffer.capacity() ? CharBuffer.allocate(this.peekLength) : this.stringBuffer;
        out.clear();
        this.utf8Decoder.reset();
        int endPos = this.reader.position() + this.peekLength;
        int limit = this.reader.limit();
        this.reader.limit(this.reader.position() + this.peekLength);
        ByteBuffer in = this.reader.toByteBuffer();
        while (!(result = this.utf8Decoder.decode(in, out, true)).isUnderflow() || !(result = this.utf8Decoder.flush(out)).isUnderflow()) {
            if (!result.isOverflow()) continue;
            CharBuffer o = CharBuffer.allocate(out.capacity() * 2);
            out.flip();
            o.put(out);
            out = o;
        }
        this.reader.limit(limit).position(endPos);
        out.flip();
        String str = out.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", (Object)this.peekType, (Object)this.peekLength, (Object)str);
        }
        return str;
    }

    @Override
    public void readStartSequence() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_SEQUENCE_SET_TRUNCATED_VALUE.get(this.peekLength));
        }
        int pos = this.reader.position();
        int endPos = pos + this.peekLength;
        this.readerStack.push(new BufferPosition(endPos, this.reader.limit()));
        this.reader.limit(endPos).position(pos);
        this.state = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("READ ASN.1 START SEQUENCE(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        }
    }

    @Override
    public void readStartExplicitTag() throws IOException {
        this.readStartSequence();
    }

    @Override
    public void readStartSet() throws IOException {
        this.readStartSequence();
    }

    @Override
    public Asn1Reader skipElement() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_SKIP_TRUNCATED_VALUE.get(this.peekLength));
        }
        this.state = 0;
        this.reader.position(this.reader.position() + this.peekLength);
        return this;
    }

    private boolean needFirstLengthByteState(boolean throwEofException) throws IOException {
        if (!this.reader.hasRemaining()) {
            if (throwEofException) {
                throw DecodeException.fatalError(CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get());
            }
            return false;
        }
        byte readByte = this.reader.get();
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            int lengthBytesNeeded = this.peekLength;
            if (lengthBytesNeeded > 4) {
                throw DecodeException.fatalError(CoreMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(lengthBytesNeeded));
            }
            this.peekLength = 0;
            if (this.reader.remaining() < lengthBytesNeeded) {
                if (throwEofException) {
                    throw DecodeException.fatalError(CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get(lengthBytesNeeded));
                }
                return false;
            }
            while (lengthBytesNeeded > 0) {
                this.peekLength = this.peekLength << 8 | this.reader.get() & 0xFF;
                --lengthBytesNeeded;
            }
        }
        if (this.peekLength < 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ASN1_NEGATIVE_LENGTH.get(this.peekLength));
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            throw DecodeException.fatalError(CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize));
        }
        this.state = 3;
        return true;
    }

    private boolean needTypeState(boolean throwEofException) throws IOException {
        if (!this.reader.hasRemaining()) {
            if (throwEofException) {
                throw DecodeException.fatalError(CoreMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get());
            }
            return false;
        }
        byte type = this.reader.get();
        this.peekType = type;
        this.state = 1;
        return true;
    }

    private static final class BufferPosition {
        final int position;
        final int limit;

        BufferPosition(int position, int limit) {
            this.position = position;
            this.limit = limit;
        }

        void apply(Buffer buffer) {
            buffer.limit(this.limit).position(this.position);
        }
    }
}

