/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.helpers.EnumHelper;
import org.forgerock.json.schema.validator.helpers.MaximumHelper;
import org.forgerock.json.schema.validator.helpers.MinimumHelper;
import org.forgerock.json.schema.validator.validators.SimpleValidator;
import org.forgerock.json.schema.validator.validators.Validator;

public class IntegerTypeValidator
extends Validator {
    private int divisibleBy = 0;
    private EnumHelper enumHelper = null;
    private SimpleValidator<Number> minimumValidator = null;
    private SimpleValidator<Number> maximumValidator = null;
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;

    public IntegerTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        int minimum = Integer.MIN_VALUE;
        int maximum = Integer.MAX_VALUE;
        boolean exclusiveMinimum = false;
        boolean exclusiveMaximum = false;
        for (Map.Entry<String, Object> e : schema.entrySet()) {
            if ("minimum".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                minimum = Math.max(((Number)e.getValue()).intValue(), minimum);
                continue;
            }
            if ("maximum".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                maximum = Math.max(minimum, ((Number)e.getValue()).intValue());
                continue;
            }
            if ("exclusiveMinimum".equals(e.getKey())) {
                if (e.getValue() instanceof Boolean) {
                    exclusiveMinimum = (Boolean)e.getValue();
                    continue;
                }
                if (!(e.getValue() instanceof String)) continue;
                exclusiveMinimum = Boolean.parseBoolean((String)e.getValue());
                continue;
            }
            if ("exclusiveMaximum".equals(e.getKey())) {
                if (e.getValue() instanceof Boolean) {
                    exclusiveMaximum = (Boolean)e.getValue();
                    continue;
                }
                if (!(e.getValue() instanceof String)) continue;
                exclusiveMaximum = Boolean.parseBoolean((String)e.getValue());
                continue;
            }
            if ("divisibleBy".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                this.divisibleBy = ((Number)e.getValue()).intValue() != 0 ? ((Number)e.getValue()).intValue() : 0;
                continue;
            }
            if (!"enum".equals(e.getKey()) || !(e.getValue() instanceof List)) continue;
            this.enumHelper = new EnumHelper((List)e.getValue());
        }
        if (Integer.MIN_VALUE != minimum) {
            this.minimumValidator = new MinimumHelper(minimum, exclusiveMinimum);
        }
        if (Integer.MIN_VALUE != maximum) {
            this.maximumValidator = new MaximumHelper(maximum, exclusiveMaximum);
        }
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if (node instanceof Number) {
            Long number = (Long)node;
            int nodeValue = this.truncate((Long)node, at, handler);
            if (null != this.minimumValidator) {
                this.minimumValidator.validate(number, this.getPath(at, null), handler);
            }
            if (null != this.maximumValidator) {
                this.maximumValidator.validate(number, this.getPath(at, null), handler);
            }
            if (0 != this.divisibleBy && nodeValue % this.divisibleBy != 0) {
                handler.error(new ValidationException("", this.getPath(at, null)));
            }
            if (null != this.enumHelper) {
                this.enumHelper.validate(node, at, handler);
            }
        } else if (null != node) {
            handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null)));
        } else if (this.required) {
            handler.error(new ValidationException("Required property violation at {}", this.getPath(at, null)));
        }
    }

    private int truncate(Long nodeValue, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if ((nodeValue & Integer.MIN_VALUE) == 0L || (nodeValue & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return nodeValue.intValue();
        }
        handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null)));
        return nodeValue.intValue();
    }
}

