/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.json.schema.validator.validators.AnyTypeValidator;
import org.forgerock.json.schema.validator.validators.ArrayTypeValidator;
import org.forgerock.json.schema.validator.validators.BooleanTypeValidator;
import org.forgerock.json.schema.validator.validators.IntegerTypeValidator;
import org.forgerock.json.schema.validator.validators.NullTypeValidator;
import org.forgerock.json.schema.validator.validators.NumberTypeValidator;
import org.forgerock.json.schema.validator.validators.ObjectTypeValidator;
import org.forgerock.json.schema.validator.validators.ReferenceTypeValidator;
import org.forgerock.json.schema.validator.validators.StringTypeValidator;
import org.forgerock.json.schema.validator.validators.UnionTypeValidator;
import org.forgerock.json.schema.validator.validators.Validator;

public final class ObjectValidatorFactory {
    private static final Map<String, Class<? extends Validator>> VALIDATORS = new HashMap<String, Class<? extends Validator>>(8);

    private ObjectValidatorFactory() {
    }

    public static Validator getTypeValidator(Map<String, Object> schema) {
        return ObjectValidatorFactory.getTypeValidator(schema, Collections.emptyList());
    }

    public static Validator getTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        Validator v = ObjectValidatorFactory.getTypeValidatorInner(schema, jsonPointer);
        if (jsonPointer.isEmpty()) {
            v.resolveSchemaReferences();
        }
        return v;
    }

    private static Validator getTypeValidatorInner(Map<String, Object> schema, List<String> jsonPointer) {
        Object typeValue = schema.get("type");
        if (null == typeValue) {
            Object refValue = schema.get("$ref");
            if (refValue instanceof String) {
                return new ReferenceTypeValidator(schema, (String)refValue, jsonPointer);
            }
            return ObjectValidatorFactory.getTypeValidator("any", schema, jsonPointer);
        }
        if (typeValue instanceof String) {
            return ObjectValidatorFactory.getTypeValidator((String)typeValue, schema, jsonPointer);
        }
        if (typeValue instanceof List) {
            return new UnionTypeValidator(schema, jsonPointer);
        }
        throw new RuntimeException("Unsupported validators exception {}");
    }

    public static Validator getTypeValidator(String type, Map<String, Object> schema, List<String> jsonPointer) {
        Class<? extends Validator> clazz = ObjectValidatorFactory.findClass(type);
        if (null != clazz) {
            try {
                return clazz.getConstructor(Map.class, List.class).newInstance(schema, jsonPointer);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to initialize the new Validator instance");
            }
        }
        throw new RuntimeException("Unsupported validators exception {}");
    }

    private static Class<? extends Validator> findClass(String type) {
        return VALIDATORS.get(type);
    }

    static {
        VALIDATORS.put("string", StringTypeValidator.class);
        VALIDATORS.put("number", NumberTypeValidator.class);
        VALIDATORS.put("integer", IntegerTypeValidator.class);
        VALIDATORS.put("boolean", BooleanTypeValidator.class);
        VALIDATORS.put("object", ObjectTypeValidator.class);
        VALIDATORS.put("array", ArrayTypeValidator.class);
        VALIDATORS.put("null", NullTypeValidator.class);
        VALIDATORS.put("any", AnyTypeValidator.class);
    }
}

