/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.utils.BigIntegerUtils;
import org.forgerock.util.encode.Base64url;

public class RsaJWK
extends JWK {
    private static final String JSON_KEY_N = "n";
    private static final String JSON_KEY_E = "e";
    private static final String JSON_KEY_D = "d";
    private static final String JSON_KEY_P = "p";
    private static final String JSON_KEY_Q = "q";
    private static final String JSON_KEY_DP = "dp";
    private static final String JSON_KEY_DQ = "dq";
    private static final String JSON_KEY_QI = "qi";
    private static final String JSON_KEY_OTH = "oth";
    private final String modulus;
    private final String publicExponent;
    private final String privateExponent;
    private final String primeP;
    private final String primeQ;
    private final String primePExponent;
    private final String primeQExponent;
    private final String crtCoefficient;
    private final List<PrimesInfo> otherPrimesInfo;

    public static Builder builder(String modulus, String publicExponent) {
        return new Builder(modulus, publicExponent);
    }

    public static Builder builder(RSAPublicKey publicKey) {
        return new Builder(publicKey);
    }

    @Deprecated
    public RsaJWK(KeyUse use, String alg, String kid, String modulus, String publicExponent, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, modulus, publicExponent, null, null, null, null, null, null, null, x5u, x5t, x5c);
    }

    @Deprecated
    public RsaJWK(KeyUse use, String alg, String kid, String modulus, String publicExponent, String privateExponent, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, modulus, publicExponent, privateExponent, null, null, null, null, null, null, x5u, x5t, x5c);
    }

    @Deprecated
    public RsaJWK(KeyUse use, String alg, String kid, String modulus, String publicExponent, String primeP, String primeQ, String primePExponent, String primeQExponent, String crtCoefficient, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, modulus, publicExponent, null, primeP, primeQ, primePExponent, primeQExponent, crtCoefficient, null, x5u, x5t, x5c);
    }

    @Deprecated
    public RsaJWK(KeyUse use, String alg, String kid, String modulus, String publicExponent, String privateExponent, String primeP, String primeQ, String primePExponent, String primeQExponent, String crtCoefficient, List<PrimesInfo> otherPrimesInfo, String x5u, String x5t, List<String> x5c) {
        super(KeyType.RSA, use, alg, kid, x5u, x5t, x5c);
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.primeP = primeP;
        this.primeQ = primeQ;
        this.primePExponent = primePExponent;
        this.primeQExponent = primeQExponent;
        this.crtCoefficient = crtCoefficient;
        this.otherPrimesInfo = otherPrimesInfo == null ? Collections.emptyList() : otherPrimesInfo;
    }

    @Deprecated
    public RsaJWK(RSAPublicKey key, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(key.getModulus()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(key.getPublicExponent()), x5u, x5t, x5c);
    }

    @Deprecated
    public RsaJWK(RSAPublicKey pubKey, RSAPrivateKey privKey, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(pubKey.getModulus()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(pubKey.getPublicExponent()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privKey.getPrivateExponent()), x5u, x5t, x5c);
    }

    @Deprecated
    public RsaJWK(RSAPublicKey pubKey, RSAPrivateCrtKey privCert, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(pubKey.getModulus()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(pubKey.getPublicExponent()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrivateExponent()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeP()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeQ()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeExponentP()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeExponentQ()), BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getCrtCoefficient()), null, x5u, x5t, x5c);
    }

    private RsaJWK(Builder builder) {
        super(KeyType.RSA, builder.use, builder.keyOperations, builder.algorithm, builder.keyId, builder.x509url, builder.x509Thumbnail, builder.x509Chain);
        this.modulus = builder.modulus;
        this.publicExponent = builder.publicExponent;
        this.privateExponent = builder.privateExponent;
        this.primeP = builder.primeP;
        this.primeQ = builder.primeQ;
        this.primePExponent = builder.primePExponent;
        this.primeQExponent = builder.primeQExponent;
        this.crtCoefficient = builder.crtCoefficient;
        this.otherPrimesInfo = builder.otherPrimesInfo;
    }

    public String getModulus() {
        return this.modulus;
    }

    public String getPublicExponent() {
        return this.publicExponent;
    }

    public String getPrivateExponent() {
        return this.privateExponent;
    }

    public String getPrimeP() {
        return this.primeP;
    }

    public String getPrimeQ() {
        return this.primeQ;
    }

    public String getPrimePExponent() {
        return this.primePExponent;
    }

    public String getPrimeQExponent() {
        return this.primeQExponent;
    }

    public String getCRTCoefficient() {
        return this.crtCoefficient;
    }

    public List<PrimesInfo> getOtherPrimesInfo() {
        return this.otherPrimesInfo;
    }

    public RSAPublicKey toRSAPublicKey() {
        try {
            RSAPublicKeySpec spec = new RSAPublicKeySpec(BigIntegerUtils.base64UrlDecode(this.getModulus()), BigIntegerUtils.base64UrlDecode(this.getPublicExponent()));
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new JsonException("Unable to create RSA Public Key", e);
        }
    }

    public RSAPrivateKey toRSAPrivateKey() {
        RSAPrivateKeySpec spec;
        if (this.getPrivateExponent() == null) {
            return null;
        }
        BigInteger modulus = BigIntegerUtils.base64UrlDecode(this.getModulus());
        BigInteger privateExponent = BigIntegerUtils.base64UrlDecode(this.getPrivateExponent());
        if (this.getPrimeP() == null) {
            spec = new RSAPrivateKeySpec(modulus, privateExponent);
        } else {
            BigInteger publicExponent = BigIntegerUtils.base64UrlDecode(this.getPublicExponent());
            BigInteger p = BigIntegerUtils.base64UrlDecode(this.getPrimeP());
            BigInteger q = BigIntegerUtils.base64UrlDecode(this.getPrimeQ());
            BigInteger dp = BigIntegerUtils.base64UrlDecode(this.getPrimePExponent());
            BigInteger dq = BigIntegerUtils.base64UrlDecode(this.getPrimeQExponent());
            BigInteger qi = BigIntegerUtils.base64UrlDecode(this.getCRTCoefficient());
            List<PrimesInfo> otherPrimesInfo = this.getOtherPrimesInfo();
            if (otherPrimesInfo != null && !otherPrimesInfo.isEmpty()) {
                RSAOtherPrimeInfo[] otherInfo = new RSAOtherPrimeInfo[otherPrimesInfo.size()];
                for (int i = 0; i < otherPrimesInfo.size(); ++i) {
                    PrimesInfo primesInfo = otherPrimesInfo.get(i);
                    BigInteger factorR = BigIntegerUtils.base64UrlDecode(primesInfo.getPrimeFactor());
                    BigInteger factorD = BigIntegerUtils.base64UrlDecode(primesInfo.getCRTExponent());
                    BigInteger factorT = BigIntegerUtils.base64UrlDecode(primesInfo.getCRTCoefficient());
                    otherInfo[i] = new RSAOtherPrimeInfo(factorR, factorD, factorT);
                }
                spec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, p, q, dp, dq, qi, otherInfo);
            } else {
                spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, p, q, dp, dq, qi);
            }
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)factory.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new JsonException("Unable to create private RSA Key", e);
        }
    }

    public KeyPair toKeyPair() {
        return new KeyPair(this.toRSAPublicKey(), this.toRSAPrivateKey());
    }

    public static RsaJWK parse(String json) {
        JsonValue jwk = new JsonValue(RsaJWK.toJsonValue(json));
        return RsaJWK.parse(jwk);
    }

    public static RsaJWK parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse RsaJWK. No json data.");
        }
        KeyType kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.RSA)) {
            throw new JsonException("Unable to parse RSA JWK; Not an RSA type");
        }
        String n = json.get(JSON_KEY_N).asString();
        String e = json.get(JSON_KEY_E).asString();
        Builder builder = RsaJWK.builder(n, e);
        RsaJWK.loadJWKFromJson(builder, json);
        if (json.get(JSON_KEY_D).isNotNull()) {
            builder.privateExponent(json.get(JSON_KEY_D).asString());
        }
        if (json.get(JSON_KEY_P).isNotNull()) {
            builder.primeP(json.get(JSON_KEY_P).asString());
        }
        if (json.get(JSON_KEY_Q).isNotNull()) {
            builder.primeQ(json.get(JSON_KEY_Q).asString());
        }
        if (json.get(JSON_KEY_DP).isNotNull()) {
            builder.primePExponent(json.get(JSON_KEY_DP).asString());
        }
        if (json.get(JSON_KEY_DQ).isNotNull()) {
            builder.primeQExponent(json.get(JSON_KEY_DQ).asString());
        }
        if (json.get(JSON_KEY_QI).isNotNull()) {
            builder.crtCoefficient(json.get(JSON_KEY_QI).asString());
        }
        if (json.get(JSON_KEY_OTH).isNotNull()) {
            ArrayList<PrimesInfo> otherPrimesInfo = new ArrayList<PrimesInfo>();
            for (JsonValue primesInfo : json.get(JSON_KEY_OTH).asList(JsonValue.class)) {
                otherPrimesInfo.add(PrimesInfo.parse(primesInfo));
            }
            builder.otherPrimesInfo(otherPrimesInfo);
        }
        return builder.build();
    }

    @Override
    public String toJsonString() {
        return super.toString();
    }

    @Override
    public JsonValue toJsonValue() {
        JsonValue jsonValue = super.toJsonValue();
        jsonValue.put(JSON_KEY_N, (Object)this.modulus);
        jsonValue.put(JSON_KEY_E, (Object)this.publicExponent);
        this.putField(jsonValue, JSON_KEY_D, this.privateExponent);
        this.putField(jsonValue, JSON_KEY_P, this.primeP);
        this.putField(jsonValue, JSON_KEY_DP, this.primePExponent);
        this.putField(jsonValue, JSON_KEY_DQ, this.primeQExponent);
        this.putField(jsonValue, JSON_KEY_QI, this.crtCoefficient);
        if (this.otherPrimesInfo != null && !this.otherPrimesInfo.isEmpty()) {
            ArrayList<JsonValue> otherPrimesInfoJson = new ArrayList<JsonValue>();
            for (PrimesInfo primesInfo : this.otherPrimesInfo) {
                otherPrimesInfoJson.add(primesInfo.toJsonValue());
            }
            jsonValue.put(JSON_KEY_OTH, otherPrimesInfoJson);
        }
        return jsonValue;
    }

    public static final class Builder
    extends JWK.Builder<Builder> {
        private final String modulus;
        private final String publicExponent;
        private String privateExponent;
        private String primeP;
        private String primeQ;
        private String primePExponent;
        private String primeQExponent;
        private String crtCoefficient;
        private List<PrimesInfo> otherPrimesInfo;

        private Builder(String modulus, String publicExponent) {
            super(KeyType.RSA);
            if (modulus == null || modulus.isEmpty()) {
                throw new IllegalArgumentException("Modulus is a required for an RSA JWK");
            }
            if (publicExponent == null || publicExponent.isEmpty()) {
                throw new IllegalArgumentException("Public exponent is a required for an RSA JWK");
            }
            this.modulus = modulus;
            this.publicExponent = publicExponent;
        }

        private Builder(RSAPublicKey publicKey) {
            super(KeyType.RSA);
            this.modulus = Base64url.encode(publicKey.getModulus().toByteArray());
            this.publicExponent = Base64url.encode(publicKey.getPublicExponent().toByteArray());
        }

        public Builder rsaPrivateCrtKey(RSAPrivateCrtKey privCert) {
            this.privateExponent(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrivateExponent()));
            this.primeP(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeP()));
            this.primeQ(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeQ()));
            this.primePExponent(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeExponentP()));
            this.primeQExponent(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getPrimeExponentQ()));
            this.crtCoefficient(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privCert.getCrtCoefficient()));
            return this;
        }

        public Builder rsaPrivateKey(RSAPrivateKey privateKey) {
            this.privateExponent(BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(privateKey.getPrivateExponent()));
            return this;
        }

        public Builder privateExponent(String privateExponent) {
            this.privateExponent = privateExponent;
            return this;
        }

        public Builder primeP(String primeP) {
            this.primeP = primeP;
            return this;
        }

        public Builder primeQ(String primeQ) {
            this.primeQ = primeQ;
            return this;
        }

        public Builder primePExponent(String primePExponent) {
            this.primePExponent = primePExponent;
            return this;
        }

        public Builder primeQExponent(String primeQExponent) {
            this.primeQExponent = primeQExponent;
            return this;
        }

        public Builder crtCoefficient(String crtCoefficient) {
            this.crtCoefficient = crtCoefficient;
            return this;
        }

        public Builder otherPrimesInfo(List<PrimesInfo> otherPrimesInfo) {
            this.otherPrimesInfo = otherPrimesInfo;
            return this;
        }

        public RsaJWK build() {
            return new RsaJWK(this);
        }
    }

    public static class PrimesInfo {
        private static final String JSON_KEY_R = "r";
        private static final String JSON_KEY_D = "d";
        private static final String JSON_KEY_T = "t";
        private String primeFactor;
        private String crtExponent;
        private String crtCoefficient;

        public PrimesInfo(String primeFactor, String crtExponent, String crtCoefficient) {
            this.primeFactor = primeFactor;
            this.crtExponent = crtExponent;
            this.crtCoefficient = crtCoefficient;
        }

        public PrimesInfo(RSAOtherPrimeInfo info) {
            this.primeFactor = BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(info.getPrime());
            this.crtExponent = BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(info.getExponent());
            this.crtCoefficient = BigIntegerUtils.base64UrlEncodeUnsignedBigIndian(info.getCrtCoefficient());
        }

        public String getPrimeFactor() {
            return this.primeFactor;
        }

        public String getCRTExponent() {
            return this.crtExponent;
        }

        public String getCRTCoefficient() {
            return this.crtCoefficient;
        }

        public JsonValue toJsonValue() {
            return JsonValue.json(JsonValue.object(JsonValue.field(JSON_KEY_R, this.primeFactor), JsonValue.field("d", this.crtExponent), JsonValue.field(JSON_KEY_T, this.crtCoefficient)));
        }

        public static PrimesInfo parse(JsonValue json) {
            String primeFactor = json.get(JSON_KEY_R).asString();
            String crtExponent = json.get("d").asString();
            String crtCoefficient = json.get(JSON_KEY_T).asString();
            return new PrimesInfo(primeFactor, crtExponent, crtCoefficient);
        }
    }
}

