/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;

@Deprecated
public abstract class AbstractEncryptionHandler
implements EncryptionHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractEncryptionHandler.class.getName());

    protected byte[] encrypt(String algorithm, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JweEncryptionException("Unsupported Encryption Algorithm, " + algorithm, e);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JweEncryptionException(e);
        }
    }

    protected byte[] encrypt(String algorithm, Key key, byte[] initialisationVector, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initialisationVector);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JweEncryptionException("Unsupported Encryption Algorithm, " + algorithm, e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JweEncryptionException(e);
        }
    }

    public byte[] decrypt(String algorithm, Key privateKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            this.logDecryptionFailure(e);
            throw new JweDecryptionException();
        }
    }

    protected byte[] decrypt(String algorithm, Key key, byte[] initialisationVector, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initialisationVector);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            this.logDecryptionFailure(e);
            throw new JweDecryptionException();
        }
    }

    private void logDecryptionFailure(Throwable cause) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Decryption failed: " + cause, cause);
        }
    }
}

