/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.security.Key;
import org.forgerock.json.jose.builders.AbstractJwtBuilder;
import org.forgerock.json.jose.builders.JwsHeaderBuilder;
import org.forgerock.json.jose.builders.JwtHeaderBuilder;
import org.forgerock.json.jose.builders.SignedJwtBuilder;
import org.forgerock.json.jose.builders.SignedThenEncryptedJwtBuilder;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.JwsHeader;
import org.forgerock.json.jose.jws.SignedJwt;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.JwtClaimsSet;

public class SignedJwtBuilderImpl
extends AbstractJwtBuilder
implements SignedJwtBuilder {
    private final SigningHandler signingHandler;

    public SignedJwtBuilderImpl(SigningHandler signingHandler) {
        this.signingHandler = signingHandler;
    }

    public JwsHeaderBuilder headers() {
        this.setJwtHeaderBuilder(new JwsHeaderBuilder(this));
        return (JwsHeaderBuilder)this.getHeaderBuilder();
    }

    @Override
    public SignedJwtBuilderImpl claims(JwtClaimsSet claimsSet) {
        return (SignedJwtBuilderImpl)super.claims(claimsSet);
    }

    public SignedThenEncryptedJwtBuilder encrypt(Key encryptionKey) {
        return new SignedThenEncryptedJwtBuilder(this, encryptionKey);
    }

    @Override
    public SignedJwt asJwt() {
        JwsHeader header;
        JwtHeaderBuilder<?, ?> headerBuilder = this.getHeaderBuilder();
        if (headerBuilder == null) {
            header = new JwsHeader();
            header.setAlgorithm(JwsAlgorithm.NONE);
        } else {
            header = (JwsHeader)this.getHeaderBuilder().build();
        }
        JwtClaimsSet claimsSet = this.getClaimsSet();
        if (claimsSet == null) {
            claimsSet = new JwtClaimsSet();
        }
        return new SignedJwt(header, claimsSet, this.signingHandler);
    }

    @Override
    public String build() {
        return this.asJwt().build();
    }
}

