/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.forgerock.http.header.AbstractSetCookieHeader;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.http.protocol.Response;
import org.forgerock.util.LambdaExceptionUtils;
import org.forgerock.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetCookie2Header
extends AbstractSetCookieHeader {
    private static final Logger logger = LoggerFactory.getLogger(SetCookie2Header.class);
    public static final String NAME = "Set-Cookie2";
    private static final String QUOTATION_MARK = "\"";
    private final List<Cookie> cookies;

    public static SetCookie2Header valueOf(String value) throws MalformedHeaderException {
        return new SetCookie2Header(SetCookie2Header.parseCookies(value));
    }

    private static List<Cookie> parseCookies(String multiValued) throws MalformedHeaderException {
        LinkedList<Cookie> cookies = new LinkedList<Cookie>();
        for (String value : HeaderUtil.parseMultiValuedHeader(multiValued)) {
            List<String> parts = Arrays.asList(value.split(";"));
            Cookie cookie = new Cookie();
            for (String part : parts) {
                String[] nvp = part.split("=", 2);
                String attributeName = nvp[0].trim();
                if ("Comment".equalsIgnoreCase(attributeName)) {
                    cookie.setComment(SetCookie2Header.attributeValue(nvp));
                    continue;
                }
                if ("CommentURL".equalsIgnoreCase(attributeName)) {
                    cookie.setCommentURL(SetCookie2Header.attributeValue(nvp).replaceAll(QUOTATION_MARK, ""));
                    continue;
                }
                if ("Discard".equalsIgnoreCase(attributeName)) {
                    cookie.setDiscard(true);
                    continue;
                }
                if ("Domain".equalsIgnoreCase(attributeName)) {
                    cookie.setDomain(SetCookie2Header.attributeValue(nvp));
                    continue;
                }
                if ("Max-Age".equalsIgnoreCase(attributeName)) {
                    cookie.setMaxAge(SetCookie2Header.parseInteger(SetCookie2Header.attributeValue(nvp)));
                    continue;
                }
                if ("Path".equalsIgnoreCase(attributeName)) {
                    cookie.setPath(SetCookie2Header.attributeValue(nvp));
                    continue;
                }
                if ("Port".equalsIgnoreCase(attributeName)) {
                    cookie.setPort(Stream.of(SetCookie2Header.attributeValue(nvp).replaceAll(QUOTATION_MARK, "").split(",")).map(String::trim).map(LambdaExceptionUtils.rethrowFunction(SetCookie2Header::parseInteger)).collect(Collectors.toList()));
                    continue;
                }
                if ("Secure".equalsIgnoreCase(attributeName)) {
                    cookie.setSecure(true);
                    continue;
                }
                if ("Version".equalsIgnoreCase(attributeName)) {
                    cookie.setVersion(SetCookie2Header.parseInteger(SetCookie2Header.attributeValue(nvp)));
                    continue;
                }
                if (Utils.isNullOrEmpty(cookie.getName()) && nvp.length > 1) {
                    cookie.setName(attributeName);
                    cookie.setValue(SetCookie2Header.attributeValue(nvp));
                    continue;
                }
                String errorMessage = "Unable to parse the Set-Cookie2 header";
                logger.error("Unable to parse the Set-Cookie2 header");
                throw new MalformedHeaderException("Unable to parse the Set-Cookie2 header");
            }
            if (Utils.isNullOrEmpty(cookie.getName())) {
                cookie = new Cookie();
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    private static String attributeValue(String[] array) throws MalformedHeaderException {
        if (array.length <= 1) {
            String errorMessage = "Malformed Set-Cookie2 header: attribute value is missing";
            logger.error("Malformed Set-Cookie2 header: attribute value is missing");
            throw new MalformedHeaderException("Malformed Set-Cookie2 header: attribute value is missing");
        }
        return array[1].trim();
    }

    public static SetCookie2Header valueOf(Response response) throws MalformedHeaderException {
        if (response == null || !response.getHeaders().containsKey(NAME)) {
            return null;
        }
        return SetCookie2Header.valueOf(response.getHeaders().get(NAME).getValues());
    }

    public static SetCookie2Header valueOf(List<String> values) throws MalformedHeaderException {
        if (values == null) {
            return null;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String headerValue : values) {
            cookies.addAll(SetCookie2Header.parseCookies(headerValue));
        }
        return new SetCookie2Header(cookies);
    }

    private static Integer parseInteger(String s) throws MalformedHeaderException {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedHeaderException("Unable to parse the values of the Set-Cookie2 header.", nfe);
        }
    }

    public SetCookie2Header(List<Cookie> cookies) {
        this.cookies = cookies != null ? Collections.unmodifiableList(new LinkedList<Cookie>(cookies)) : Collections.emptyList();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (Cookie cookie : this.cookies) {
            values.add(SetCookie2Header.toString(cookie));
        }
        return values;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    private static String toString(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        if (cookie.getName() != null) {
            sb.append(cookie.getName()).append("=").append(cookie.getValue());
            if (cookie.getComment() != null) {
                sb.append("; ").append("Comment").append("=").append(cookie.getComment());
            }
            if (cookie.getCommentURL() != null) {
                sb.append("; ").append("CommentURL").append("=").append(QUOTATION_MARK).append(cookie.getCommentURL()).append(QUOTATION_MARK);
            }
            if (cookie.getDiscard() != null && cookie.getDiscard().booleanValue()) {
                sb.append("; ").append("Discard");
            }
            if (cookie.getDomain() != null) {
                sb.append("; ").append("Domain").append("=").append(cookie.getDomain());
            }
            if (cookie.getMaxAge() != null && cookie.getMaxAge() > 0) {
                sb.append("; ").append("Max-Age").append("=").append(cookie.getMaxAge());
            }
            if (cookie.getPath() != null) {
                sb.append("; ").append("Path").append("=").append(cookie.getPath());
            }
            if (cookie.getPort() != null && !cookie.getPort().isEmpty()) {
                sb.append("; ").append("Port").append("=").append(QUOTATION_MARK);
                sb.append(cookie.getPort().stream().map(Object::toString).collect(Collectors.joining(",")));
                sb.append(QUOTATION_MARK);
            }
            if (cookie.isSecure() != null && cookie.isSecure().booleanValue()) {
                sb.append("; ").append("Secure");
            }
            if (cookie.getVersion() != null) {
                sb.append("; ").append("Version").append("=").append(cookie.getVersion());
            }
        }
        return sb.toString();
    }

    static class Factory
    extends HeaderFactory<SetCookie2Header> {
        Factory() {
        }

        @Override
        public SetCookie2Header parse(String value) throws MalformedHeaderException {
            return SetCookie2Header.valueOf(value);
        }

        @Override
        public SetCookie2Header parse(List<String> values) throws MalformedHeaderException {
            return SetCookie2Header.valueOf(values);
        }
    }
}

