/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.AcceptLanguageHeader;
import org.forgerock.http.header.ConnectionHeader;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentEncodingHeader;
import org.forgerock.http.header.ContentLengthHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.CookieHeader;
import org.forgerock.http.header.LocationHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.header.SetCookie2Header;
import org.forgerock.http.header.SetCookieHeader;
import org.forgerock.http.header.TransactionIdHeader;
import org.forgerock.http.header.WarningHeader;
import org.forgerock.http.protocol.Header;

public abstract class HeaderFactory<H extends Header> {
    public static final Map<Class<? extends Header>, String> HEADER_NAMES;
    public static final Map<String, HeaderFactory<?>> FACTORIES;

    private static void register(Map<Class<? extends Header>, String> names, Map<String, HeaderFactory<?>> factories, String name, Class<? extends Header> clazz, HeaderFactory<?> factory) {
        names.put(clazz, name);
        factories.put(name, factory);
    }

    protected abstract H parse(String var1) throws MalformedHeaderException;

    protected abstract H parse(List<String> var1) throws MalformedHeaderException;

    public H parse(Object value) throws MalformedHeaderException {
        try {
            if (value instanceof Header) {
                return this.parse(new ArrayList<String>(((Header)value).getValues()));
            }
            if (value instanceof String) {
                String s = (String)value;
                return s.isEmpty() ? null : (H)this.parse(s);
            }
            if (value instanceof List) {
                return this.parse((List)value);
            }
            if (value.getClass().isArray()) {
                return this.parse(Arrays.asList((String[])value));
            }
        }
        catch (RuntimeException e) {
            throw new MalformedHeaderException("Could not parse header", e);
        }
        throw new IllegalArgumentException("Cannot parse header value from type: " + value);
    }

    static {
        HashMap<Class<? extends Header>, String> n = new HashMap<Class<? extends Header>, String>();
        TreeMap f = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        HeaderFactory.register(n, f, "Accept-API-Version", AcceptApiVersionHeader.class, new AcceptApiVersionHeader.Factory());
        HeaderFactory.register(n, f, "Accept-Language", AcceptLanguageHeader.class, new AcceptLanguageHeader.Factory());
        HeaderFactory.register(n, f, "Connection", ConnectionHeader.class, new ConnectionHeader.Factory());
        HeaderFactory.register(n, f, "Content-API-Version", ContentApiVersionHeader.class, new ContentApiVersionHeader.Factory());
        HeaderFactory.register(n, f, "Content-Encoding", ContentEncodingHeader.class, new ContentEncodingHeader.Factory());
        HeaderFactory.register(n, f, "Content-Length", ContentLengthHeader.class, new ContentLengthHeader.Factory());
        HeaderFactory.register(n, f, "Content-Type", ContentTypeHeader.class, new ContentTypeHeader.Factory());
        HeaderFactory.register(n, f, "Cookie", CookieHeader.class, new CookieHeader.Factory());
        HeaderFactory.register(n, f, "Location", LocationHeader.class, new LocationHeader.Factory());
        HeaderFactory.register(n, f, "Set-Cookie", SetCookieHeader.class, new SetCookieHeader.Factory());
        HeaderFactory.register(n, f, "Set-Cookie2", SetCookie2Header.class, new SetCookie2Header.Factory());
        HeaderFactory.register(n, f, "X-ForgeRock-TransactionId", TransactionIdHeader.class, new TransactionIdHeader.Factory());
        HeaderFactory.register(n, f, "Warning", WarningHeader.class, new WarningHeader.Factory());
        HEADER_NAMES = Collections.unmodifiableMap(n);
        FACTORIES = Collections.unmodifiableMap(f);
    }
}

