/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.async;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.forgerock.util.Factory;

abstract class CloseableBufferFactory<T extends Buffer>
implements Factory<CloseableBuffer> {
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();

    static CloseableBufferFactory<ByteBuffer> closeableByteBufferFactory(int poolInitialSize, final int bufferSize) {
        return new CloseableBufferFactory<ByteBuffer>(poolInitialSize){

            @Override
            protected ByteBuffer allocate() {
                return ByteBuffer.allocate(bufferSize);
            }
        };
    }

    CloseableBufferFactory(int poolInitialSize) {
        for (int i = 0; i < poolInitialSize; ++i) {
            this.pool.add(this.allocate());
        }
    }

    protected abstract T allocate();

    @Override
    public final CloseableBuffer newInstance() {
        Buffer instance = (Buffer)this.pool.poll();
        if (instance == null) {
            instance = this.allocate();
        }
        return new CloseableBuffer(this, instance);
    }

    static final class CloseableBuffer
    implements AutoCloseable {
        private final T buffer;
        final /* synthetic */ CloseableBufferFactory this$0;

        private CloseableBuffer(T buffer) {
            this.this$0 = this$0;
            this.buffer = buffer;
        }

        @Override
        public void close() {
            ((Buffer)this.buffer).clear();
            this.this$0.pool.add(this.buffer);
        }

        T getBuffer() {
            return this.buffer;
        }
    }
}

