/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.model.internal;

import com.inwebo.repackaged.com.google.common.base.Predicate;
import com.inwebo.repackaged.com.google.common.base.Predicates;
import com.inwebo.repackaged.com.google.common.collect.Maps;
import com.inwebo.repackaged.com.google.common.collect.Sets;
import com.inwebo.repackaged.javax.annotation.Priority;
import com.inwebo.repackaged.javax.inject.Scope;
import com.inwebo.repackaged.javax.ws.rs.NameBinding;
import com.inwebo.repackaged.javax.ws.rs.core.Feature;
import com.inwebo.repackaged.org.glassfish.hk2.utilities.Binder;
import com.inwebo.repackaged.org.glassfish.jersey.Severity;
import com.inwebo.repackaged.org.glassfish.jersey.internal.Errors;
import com.inwebo.repackaged.org.glassfish.jersey.internal.LocalizationMessages;
import com.inwebo.repackaged.org.glassfish.jersey.internal.inject.Providers;
import com.inwebo.repackaged.org.glassfish.jersey.internal.util.Producer;
import com.inwebo.repackaged.org.glassfish.jersey.model.ContractProvider;
import com.inwebo.repackaged.org.glassfish.jersey.process.Inflector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ComponentBag {
    public static final Predicate<ContractProvider> EXCLUDE_META_PROVIDERS = new Predicate<ContractProvider>(){

        @Override
        public boolean apply(ContractProvider model) {
            Set<Class<?>> contracts = model.getContracts();
            if (contracts.isEmpty()) {
                return true;
            }
            int count = 0;
            if (contracts.contains(Feature.class)) {
                count = (byte)(count + 1);
            }
            if (contracts.contains(Binder.class)) {
                count = (byte)(count + 1);
            }
            return contracts.size() > count;
        }
    };
    public static final Predicate<ContractProvider> BINDERS_ONLY = new Predicate<ContractProvider>(){

        @Override
        public boolean apply(ContractProvider model) {
            return model.getContracts().contains(Binder.class);
        }
    };
    public static final Predicate<ContractProvider> EXCLUDE_EMPTY = new Predicate<ContractProvider>(){

        @Override
        public boolean apply(ContractProvider model) {
            return !model.getContracts().isEmpty();
        }
    };
    public static final Predicate<ContractProvider> INCLUDE_ALL = Predicates.alwaysTrue();
    public static final Inflector<ContractProvider.Builder, ContractProvider> AS_IS = new Inflector<ContractProvider.Builder, ContractProvider>(){

        @Override
        public ContractProvider apply(ContractProvider.Builder builder) {
            return builder.build();
        }
    };
    private final Predicate<ContractProvider> registrationStrategy;
    private final Set<Class<?>> classes;
    private final Set<Class<?>> classesView;
    private final Set<Object> instances;
    private final Set<Object> instancesView;
    private final Map<Class<?>, ContractProvider> models;
    private final Set<Class<?>> modelKeysView;

    public static ComponentBag newInstance(Predicate<ContractProvider> registrationStrategy) {
        return new ComponentBag(registrationStrategy);
    }

    private ComponentBag(Predicate<ContractProvider> registrationStrategy) {
        this.registrationStrategy = registrationStrategy;
        this.classes = Sets.newLinkedHashSet();
        this.instances = Sets.newLinkedHashSet();
        this.models = Maps.newIdentityHashMap();
        this.classesView = Collections.unmodifiableSet(this.classes);
        this.instancesView = Collections.unmodifiableSet(this.instances);
        this.modelKeysView = Collections.unmodifiableSet(this.models.keySet());
    }

    private ComponentBag(Predicate<ContractProvider> registrationStrategy, Set<Class<?>> classes, Set<Object> instances, Map<Class<?>, ContractProvider> models) {
        this.registrationStrategy = registrationStrategy;
        this.classes = classes;
        this.instances = instances;
        this.models = models;
        this.classesView = Collections.unmodifiableSet(classes);
        this.instancesView = Collections.unmodifiableSet(instances);
        this.modelKeysView = Collections.unmodifiableSet(models.keySet());
    }

    public boolean register(Class<?> componentClass, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        boolean result = this.registerModel(componentClass, -1, null, modelEnhancer);
        if (result) {
            this.classes.add(componentClass);
        }
        return result;
    }

    public boolean register(Class<?> componentClass, int priority, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        boolean result = this.registerModel(componentClass, priority, null, modelEnhancer);
        if (result) {
            this.classes.add(componentClass);
        }
        return result;
    }

    public boolean register(Class<?> componentClass, Set<Class<?>> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        boolean result = this.registerModel(componentClass, -1, ComponentBag.asMap(contracts), modelEnhancer);
        if (result) {
            this.classes.add(componentClass);
        }
        return result;
    }

    public boolean register(Class<?> componentClass, Map<Class<?>, Integer> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        boolean result = this.registerModel(componentClass, -1, contracts, modelEnhancer);
        if (result) {
            this.classes.add(componentClass);
        }
        return result;
    }

    public boolean register(Object component, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        Class<?> componentClass = component.getClass();
        boolean result = this.registerModel(componentClass, -1, null, modelEnhancer);
        if (result) {
            this.instances.add(component);
        }
        return result;
    }

    public boolean register(Object component, int priority, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        Class<?> componentClass = component.getClass();
        boolean result = this.registerModel(componentClass, priority, null, modelEnhancer);
        if (result) {
            this.instances.add(component);
        }
        return result;
    }

    public boolean register(Object component, Set<Class<?>> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        Class<?> componentClass = component.getClass();
        boolean result = this.registerModel(componentClass, -1, ComponentBag.asMap(contracts), modelEnhancer);
        if (result) {
            this.instances.add(component);
        }
        return result;
    }

    public boolean register(Object component, Map<Class<?>, Integer> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        Class<?> componentClass = component.getClass();
        boolean result = this.registerModel(componentClass, -1, contracts, modelEnhancer);
        if (result) {
            this.instances.add(component);
        }
        return result;
    }

    private boolean registerModel(final Class<?> componentClass, final int defaultPriority, final Map<Class<?>, Integer> contractMap, final Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        return Errors.process(new Producer<Boolean>(){

            @Override
            public Boolean call() {
                if (ComponentBag.this.models.containsKey(componentClass)) {
                    Errors.error(LocalizationMessages.COMPONENT_TYPE_ALREADY_REGISTERED(componentClass), Severity.HINT);
                    return false;
                }
                ContractProvider model = ComponentBag.modelFor(componentClass, defaultPriority, contractMap, modelEnhancer);
                if (!ComponentBag.this.registrationStrategy.apply(model)) {
                    return false;
                }
                ComponentBag.this.models.put(componentClass, model);
                return true;
            }
        });
    }

    public static ContractProvider modelFor(Class<?> componentClass) {
        return ComponentBag.modelFor(componentClass, -1, null, AS_IS);
    }

    private static ContractProvider modelFor(Class<?> componentClass, int defaultPriority, Map<Class<?>, Integer> contractMap, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
        Map<Class<?>, Integer> contracts = contractMap;
        if (contracts == null) {
            contracts = ComponentBag.asMap(Providers.getProviderContracts(componentClass));
        } else {
            Iterator<Class<?>> it = contracts.keySet().iterator();
            while (it.hasNext()) {
                Class<?> contract = it.next();
                if (contract == null) {
                    it.remove();
                    continue;
                }
                boolean failed = false;
                if (!Providers.isSupportedContract(contract)) {
                    Errors.error(LocalizationMessages.CONTRACT_NOT_SUPPORTED(contract, componentClass), Severity.WARNING);
                    failed = true;
                }
                if (!contract.isAssignableFrom(componentClass)) {
                    Errors.error(LocalizationMessages.CONTRACT_NOT_ASSIGNABLE(contract, componentClass), Severity.WARNING);
                    failed = true;
                }
                if (!failed) continue;
                it.remove();
            }
        }
        ContractProvider.Builder builder = ContractProvider.builder().addContracts(contracts).defaultPriority(defaultPriority);
        boolean useAnnotationPriority = defaultPriority == -1;
        for (Annotation annotation : componentClass.getAnnotations()) {
            if (annotation instanceof Priority) {
                if (!useAnnotationPriority) continue;
                builder.defaultPriority(((Priority)annotation).value());
                continue;
            }
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (metaAnnotation instanceof NameBinding) {
                    builder.addNameBinding(annotation.annotationType());
                }
                if (!(metaAnnotation instanceof Scope)) continue;
                builder.scope(annotation.annotationType());
            }
        }
        return modelEnhancer.apply(builder);
    }

    private static Map<Class<?>, Integer> asMap(Set<Class<?>> contractSet) {
        IdentityHashMap contracts = new IdentityHashMap();
        for (Class<?> contract : contractSet) {
            contracts.put(contract, -1);
        }
        return contracts;
    }

    public Set<Class<?>> getClasses() {
        return this.classesView;
    }

    public Set<Object> getInstances() {
        return this.instancesView;
    }

    public Set<Class<?>> getClasses(final Predicate<ContractProvider> filter) {
        return Sets.filter(this.classesView, new Predicate<Class<?>>(){

            @Override
            public boolean apply(Class<?> input) {
                ContractProvider model = ComponentBag.this.getModel(input);
                return filter.apply(model);
            }
        });
    }

    public Set<Object> getInstances(final Predicate<ContractProvider> filter) {
        return Sets.filter(this.instancesView, new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                ContractProvider model = ComponentBag.this.getModel(input.getClass());
                return filter.apply(model);
            }
        });
    }

    public Set<Class<?>> getRegistrations() {
        return this.modelKeysView;
    }

    public ContractProvider getModel(Class<?> componentClass) {
        return this.models.get(componentClass);
    }

    public ComponentBag copy() {
        return new ComponentBag(this.registrationStrategy, Sets.newLinkedHashSet(this.classes), Sets.newLinkedHashSet(this.instances), new IdentityHashMap(this.models));
    }

    public ComponentBag immutableCopy() {
        return new ImmutableComponentBag(this);
    }

    public void clear() {
        this.classes.clear();
        this.instances.clear();
        this.models.clear();
    }

    public void loadFrom(ComponentBag bag) {
        this.clear();
        this.classes.addAll(bag.classes);
        this.instances.addAll(bag.instances);
        this.models.putAll(bag.models);
    }

    private static class ImmutableComponentBag
    extends ComponentBag {
        public ImmutableComponentBag(ComponentBag original) {
            super(original.registrationStrategy, Sets.newLinkedHashSet(original.classes), Sets.newLinkedHashSet(original.instances), new IdentityHashMap(original.models));
        }

        @Override
        public boolean register(Class<?> componentClass, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Class<?> componentClass, int priority, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Class<?> componentClass, Set<Class<?>> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Class<?> componentClass, Map<Class<?>, Integer> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Object component, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Object component, int priority, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Object component, Set<Class<?>> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public boolean register(Object component, Map<Class<?>, Integer> contracts, Inflector<ContractProvider.Builder, ContractProvider> modelEnhancer) {
            throw new IllegalStateException("This instance is read-only.");
        }

        @Override
        public ComponentBag copy() {
            return this;
        }

        @Override
        public ComponentBag immutableCopy() {
            return this;
        }

        @Override
        public void clear() {
            throw new IllegalStateException("This instance is read-only.");
        }
    }
}

