/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.reactive;

import io.reactivex.FlowableOperator;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BlockingBackpressureOperator<T>
implements FlowableOperator<T, T> {
    private final long timeout;
    private final TimeUnit timeUnit;

    public static <T> FlowableOperator<T, T> newBlockingBackpressure(Class<T> klass, long timeout, TimeUnit timeUnit) {
        return new BlockingBackpressureOperator<T>(timeout, timeUnit);
    }

    private BlockingBackpressureOperator(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public Subscriber<? super T> apply(Subscriber<? super T> subscriber) throws Exception {
        return new BlockingSubscriberWrapper(subscriber);
    }

    private static final class BackpressureSemaphore
    extends AbstractQueuedLongSynchronizer {
        private static final boolean UNBLOCK_THREAD = true;
        private static final int BLOCK_THREAD = -1;
        private static final long UNBOUND = Long.MAX_VALUE;
        private static final long DONE = Long.MIN_VALUE;

        private BackpressureSemaphore() {
        }

        void allowPublisherToEmits(long n) {
            this.releaseShared(n);
        }

        boolean blockUntilAllowedToEmit(long timeOut, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            if (!this.tryAcquireSharedNanos(1L, timeUnit.toNanos(timeOut))) {
                throw new TimeoutException("Unable to emit");
            }
            return this.getState() != Long.MIN_VALUE;
        }

        boolean trySetStateDone() {
            long state;
            do {
                if ((state = this.getState()) != Long.MIN_VALUE) continue;
                return false;
            } while (!this.compareAndSetState(state, Long.MIN_VALUE));
            this.releaseShared(Long.MIN_VALUE);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(long n) {
            long previousState;
            if (n == Long.MIN_VALUE || n == Long.MAX_VALUE) {
                this.setState(n);
                return true;
            }
            do {
                if ((previousState = this.getState()) != Long.MIN_VALUE && previousState != Long.MAX_VALUE) continue;
                return true;
            } while (!this.compareAndSetState(previousState, BackpressureHelper.addCap(previousState, n)));
            return previousState == 0L;
        }

        @Override
        protected long tryAcquireShared(long n) {
            long newState;
            long state;
            do {
                if ((state = this.getState()) == Long.MIN_VALUE || state == Long.MAX_VALUE) {
                    return 1L;
                }
                if (state != 0L) continue;
                return -1L;
            } while (!this.compareAndSetState(state, newState = state - n));
            return newState;
        }
    }

    private final class BlockingSubscriberWrapper
    implements Subscriber<T> {
        private final BackpressureSemaphore semaphore = new BackpressureSemaphore();
        private final Subscriber<? super T> downstreamSubscriber;
        private volatile Subscription upstreamSubscription;

        public BlockingSubscriberWrapper(Subscriber<? super T> subscriber) {
            this.downstreamSubscriber = subscriber;
            this.downstreamSubscriber.onSubscribe(new Subscription(){

                @Override
                public void request(long n) {
                    BlockingSubscriberWrapper.this.semaphore.allowPublisherToEmits(n);
                }

                @Override
                public void cancel() {
                    if (BlockingSubscriberWrapper.this.semaphore.trySetStateDone() && BlockingSubscriberWrapper.this.upstreamSubscription != null) {
                        BlockingSubscriberWrapper.this.upstreamSubscription.cancel();
                    }
                }
            });
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.upstreamSubscription != null) {
                s.cancel();
                return;
            }
            this.upstreamSubscription = s;
            this.upstreamSubscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            try {
                if (this.semaphore.blockUntilAllowedToEmit(BlockingBackpressureOperator.this.timeout, BlockingBackpressureOperator.this.timeUnit)) {
                    this.downstreamSubscriber.onNext(item);
                }
            }
            catch (InterruptedException | TimeoutException e) {
                this.upstreamSubscription.cancel();
                this.onError(e);
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.semaphore.trySetStateDone()) {
                this.downstreamSubscriber.onError(error);
            }
        }

        @Override
        public void onComplete() {
            if (this.semaphore.trySetStateDone()) {
                this.downstreamSubscriber.onComplete();
            }
        }
    }
}

