/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TrailingArgumentsConstraints;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizableMessage;

public class SubCommand
implements DocDescriptionSupplement {
    private boolean isHidden;
    private final Map<Character, Argument> shortIdMap = new HashMap<Character, Argument>();
    private final Map<String, Argument> longIdMap = new TreeMap<String, Argument>(String.CASE_INSENSITIVE_ORDER);
    private final List<Argument> arguments = new LinkedList<Argument>();
    private LocalizableMessage description;
    private String name;
    private SubCommandArgumentParser parser;
    private final TrailingArgumentsConstraints trailingArgumentsConstraints;
    private LocalizableMessage docDescriptionSupplement;

    public SubCommand(SubCommandArgumentParser parser, String name, LocalizableMessage description) {
        this(parser, name, new TrailingArgumentsConstraints(), description);
    }

    public SubCommand(SubCommandArgumentParser parser, String name, TrailingArgumentsConstraints trailingArgumentsConstraints, LocalizableMessage description) {
        this.parser = parser;
        this.name = name;
        this.description = description;
        this.trailingArgumentsConstraints = trailingArgumentsConstraints;
        this.isHidden = false;
        parser.addSubCommand(this);
    }

    public String getName() {
        return this.name;
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    @Override
    public LocalizableMessage getDocDescriptionSupplement() {
        return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
    }

    public void setDocDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
        this.docDescriptionSupplement = docDescriptionSupplement;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Argument getArgument(Character shortID) {
        return this.shortIdMap.get(shortID);
    }

    public Argument getArgument(String longIdentifier) {
        return this.longIdMap.get(longIdentifier);
    }

    public <A extends Argument> A addArgument(A argument) {
        String argumentLongID = argument.getLongIdentifier();
        if (this.getArgument(argumentLongID) != null) {
            throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_LONG_ID.get(argumentLongID, this.name).toString());
        }
        if (this.parser.getArgumentForLongId(argumentLongID) != null) {
            throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_GLOBAL_CONFLICT.get(argumentLongID, this.name).toString());
        }
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            if (this.shortIdMap.containsKey(shortID)) {
                throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_SHORT_ID.get(argumentLongID, this.name, shortID, this.shortIdMap.get(shortID).getLongIdentifier()).toString());
            }
            Argument arg = this.parser.getArgumentForShortId(shortID);
            if (arg != null) {
                throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_SHORT_ID_GLOBAL_CONFLICT.get(argumentLongID, this.name, shortID, arg.getLongIdentifier()).toString());
            }
        }
        if (this.parser.getArgumentForLongId(argumentLongID) != null) {
            throw new IllegalArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_LONG_ID_GLOBAL_CONFLICT.get(argumentLongID, this.name).toString());
        }
        this.arguments.add(argument);
        if (shortID != null) {
            this.shortIdMap.put(shortID, argument);
        }
        this.longIdMap.put(argumentLongID, argument);
        return argument;
    }

    TrailingArgumentsConstraints getTrailingArgumentsConstraints() {
        return this.trailingArgumentsConstraints;
    }

    public List<String> getTrailingArguments() {
        return this.parser.getTrailingArguments();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(").append("name=").append(this.name);
        if (!this.longIdMap.isEmpty()) {
            sb.append(", longIDs=").append(this.longIdMap.keySet());
        }
        if (!this.shortIdMap.isEmpty()) {
            sb.append(", shortIDs=").append(this.shortIdMap.keySet());
        }
        sb.append(")");
        return sb.toString();
    }
}

